/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.interactions;

import org.nakedobjects.applib.events.InteractionEvent;
import org.nakedobjects.metamodel.consent.InteractionResult;
import org.nakedobjects.metamodel.consent.InteractionResultSet;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetFilters;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.interactions.DisablingInteractionAdvisor;
import org.nakedobjects.metamodel.interactions.HidingInteractionAdvisor;
import org.nakedobjects.metamodel.interactions.UsabilityContext;
import org.nakedobjects.metamodel.interactions.ValidatingInteractionAdvisor;
import org.nakedobjects.metamodel.interactions.ValidityContext;
import org.nakedobjects.metamodel.interactions.VisibilityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InteractionUtils {
    private InteractionUtils() {
    }

    public static InteractionResult isVisibleResult(FacetHolder facetHolder, VisibilityContext<?> context) {
        InteractionResult result = new InteractionResult((InteractionEvent)context.createInteractionEvent());
        Facet[] facets = facetHolder.getFacets(FacetFilters.isA(HidingInteractionAdvisor.class));
        for (int i = 0; i < facets.length; ++i) {
            HidingInteractionAdvisor advisor = (HidingInteractionAdvisor)facets[i];
            result.advise(advisor.hides(context), advisor);
        }
        return result;
    }

    public static InteractionResultSet isVisibleResultSet(FacetHolder facetHolder, VisibilityContext<?> context, InteractionResultSet resultSet) {
        return resultSet.add(InteractionUtils.isVisibleResult(facetHolder, context));
    }

    public static InteractionResult isUsableResult(FacetHolder facetHolder, UsabilityContext<?> context) {
        InteractionResult result = new InteractionResult((InteractionEvent)context.createInteractionEvent());
        Facet[] facets = facetHolder.getFacets(FacetFilters.isA(DisablingInteractionAdvisor.class));
        for (int i = 0; i < facets.length; ++i) {
            DisablingInteractionAdvisor advisor = (DisablingInteractionAdvisor)facets[i];
            String disables = advisor.disables(context);
            result.advise(disables, advisor);
        }
        return result;
    }

    public static InteractionResultSet isUsableResultSet(FacetHolder facetHolder, UsabilityContext<?> context, InteractionResultSet resultSet) {
        return resultSet.add(InteractionUtils.isUsableResult(facetHolder, context));
    }

    public static InteractionResult isValidResult(FacetHolder facetHolder, ValidityContext<?> context) {
        InteractionResult result = new InteractionResult((InteractionEvent)context.createInteractionEvent());
        Facet[] facets = facetHolder.getFacets(FacetFilters.isA(ValidatingInteractionAdvisor.class));
        for (int i = 0; i < facets.length; ++i) {
            ValidatingInteractionAdvisor advisor = (ValidatingInteractionAdvisor)facets[i];
            result.advise(advisor.invalidates(context), advisor);
        }
        return result;
    }

    public static InteractionResultSet isValidResultSet(FacetHolder facetHolder, ValidityContext<?> context, InteractionResultSet resultSet) {
        return resultSet.add(InteractionUtils.isValidResult(facetHolder, context));
    }
}

