/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.java5;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.commons.lang.JavaClassUtils;
import org.nakedobjects.metamodel.facets.FacetFactoryAbstract;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveSuperclassMethodsFacetFactory
extends FacetFactoryAbstract {
    private static final String JAVA_CLASS_PREFIX = "java.";

    public RemoveSuperclassMethodsFacetFactory() {
        super(NakedObjectFeatureType.OBJECTS_ONLY);
    }

    @Override
    public boolean process(Class<?> type, MethodRemover methodRemover, FacetHolder holder) {
        this.removeSuperclassMethods(type, methodRemover);
        return false;
    }

    private void removeSuperclassMethods(Class<?> type, MethodRemover methodRemover) {
        if (type == null) {
            return;
        }
        if (!JavaClassUtils.isJavaClass(type)) {
            this.removeSuperclassMethods(type.getSuperclass(), methodRemover);
            return;
        }
        Method[] methods = type.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Method method = methods[j];
            methodRemover.removeMethod(method);
        }
    }
}

