/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.runtimecontext.spec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.adapter.Instance;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.filters.Filter;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.InteractionInvocationMethod;
import org.nakedobjects.metamodel.consent.InteractionResult;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.hide.HiddenFacet;
import org.nakedobjects.metamodel.facets.object.aggregated.AggregatedFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.facets.object.immutable.ImmutableFacet;
import org.nakedobjects.metamodel.facets.object.parseable.ParseableFacet;
import org.nakedobjects.metamodel.facets.object.value.ValueFacet;
import org.nakedobjects.metamodel.interactions.InteractionUtils;
import org.nakedobjects.metamodel.interactions.ObjectTitleContext;
import org.nakedobjects.metamodel.interactions.ObjectValidityContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.spec.feature.NakedObjectActionSet;
import org.nakedobjects.metamodel.spec.IntrospectableSpecification;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.Persistability;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionParameter;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociationFilters;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntrospectableSpecificationAbstract
extends FacetHolderImpl
implements NakedObjectSpecification,
IntrospectableSpecification {
    private boolean introspected = false;
    protected String fullName;
    protected NakedObjectAssociation[] fields;
    protected NakedObjectAction[] objectActions;
    protected NakedObjectSpecification superClassSpecification;
    protected Identifier identifier;
    private final RuntimeContext runtimeContext;

    public IntrospectableSpecificationAbstract(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getIconName(NakedObject object) {
        return null;
    }

    @Override
    public boolean hasSubclasses() {
        return false;
    }

    @Override
    public NakedObjectSpecification[] interfaces() {
        return new NakedObjectSpecification[0];
    }

    @Override
    public NakedObjectSpecification[] subclasses() {
        return new NakedObjectSpecification[0];
    }

    @Override
    public NakedObjectSpecification superclass() {
        return this.superClassSpecification;
    }

    @Override
    public boolean isOfType(NakedObjectSpecification specification) {
        return specification == this;
    }

    @Override
    public void addSubclass(NakedObjectSpecification specification) {
    }

    @Override
    public Instance getInstance(NakedObject nakedObject) {
        return nakedObject;
    }

    protected void setIntrospected(boolean introspected) {
        this.introspected = introspected;
    }

    @Override
    public boolean isIntrospected() {
        return this.introspected;
    }

    public <Q extends Facet> Q getFacet(Class<Q> facetType) {
        Q facet = super.getFacet(facetType);
        Q noopFacet = null;
        if (this.isNotANoopFacet((Facet)facet)) {
            return facet;
        }
        noopFacet = facet;
        if (this.superclass() != null) {
            Q superClassFacet = this.superclass().getFacet(facetType);
            if (this.isNotANoopFacet((Facet)superClassFacet)) {
                return superClassFacet;
            }
            if (noopFacet == null) {
                noopFacet = superClassFacet;
            }
        }
        if (this.interfaces() != null) {
            NakedObjectSpecification[] interfaces = this.interfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                NakedObjectSpecification interfaceSpec = interfaces[i];
                if (interfaceSpec == null) continue;
                Q interfaceFacet = interfaceSpec.getFacet(facetType);
                if (this.isNotANoopFacet((Facet)interfaceFacet)) {
                    return interfaceFacet;
                }
                if (noopFacet != null) continue;
                noopFacet = interfaceFacet;
            }
        }
        return noopFacet;
    }

    private boolean isNotANoopFacet(Facet facet) {
        return facet != null && !facet.isNoop();
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public ObjectTitleContext createTitleInteractionContext(AuthenticationSession session, InteractionInvocationMethod interactionMethod, NakedObject targetNakedObject) {
        return new ObjectTitleContext(session, interactionMethod, targetNakedObject, this.getIdentifier(), targetNakedObject.titleString());
    }

    @Override
    public NakedObjectAssociation[] getAssociations() {
        return this.fields;
    }

    @Override
    public List<? extends NakedObjectAssociation> getAssociationList() {
        return Arrays.asList(this.fields);
    }

    @Override
    public NakedObjectAssociation[] getAssociations(Filter<NakedObjectAssociation> filter) {
        NakedObjectAssociation[] allFields = this.getAssociations();
        NakedObjectAssociation[] selectedFields = new NakedObjectAssociation[allFields.length];
        int v = 0;
        for (int i = 0; i < allFields.length; ++i) {
            if (!filter.accept(allFields[i])) continue;
            selectedFields[v++] = allFields[i];
        }
        NakedObjectAssociation[] fields = new NakedObjectAssociation[v];
        System.arraycopy(selectedFields, 0, fields, 0, v);
        return fields;
    }

    @Override
    public List<? extends NakedObjectAssociation> getAssociationList(Filter<NakedObjectAssociation> filter) {
        return Arrays.asList(this.getAssociations(filter));
    }

    @Override
    public List<OneToOneAssociation> getPropertyList() {
        ArrayList<OneToOneAssociation> list = new ArrayList<OneToOneAssociation>();
        List<? extends NakedObjectAssociation> associationList = this.getAssociationList(NakedObjectAssociationFilters.PROPERTIES);
        list.addAll(associationList);
        return list;
    }

    @Override
    public List<OneToManyAssociation> getCollectionList() {
        ArrayList<OneToManyAssociation> list = new ArrayList<OneToManyAssociation>();
        List<? extends NakedObjectAssociation> associationList = this.getAssociationList(NakedObjectAssociationFilters.COLLECTIONS);
        list.addAll(associationList);
        return list;
    }

    protected NakedObjectAction[] getActions(NakedObjectAction[] availableActions, NakedObjectActionType type) {
        return new NakedObjectAction[0];
    }

    @Override
    public NakedObjectAction[] getObjectActions(NakedObjectActionType ... types) {
        List<? extends NakedObjectAction> actions = this.getObjectActionList(types);
        return actions.toArray(new NakedObjectAction[0]);
    }

    @Override
    public List<? extends NakedObjectAction> getObjectActionList(NakedObjectActionType ... types) {
        ArrayList<NakedObjectAction> actions = new ArrayList<NakedObjectAction>();
        for (NakedObjectActionType type : types) {
            this.addActions(type, actions);
        }
        return actions;
    }

    private void addActions(NakedObjectActionType type, List<NakedObjectAction> actions) {
        if (!this.isService()) {
            actions.addAll(Arrays.asList(this.getServiceActions(type)));
        }
        actions.addAll(Arrays.asList(this.getActions(this.objectActions, type)));
    }

    @Override
    public NakedObjectAction[] getServiceActionsFor(NakedObjectActionType type) {
        List<NakedObject> services = this.getRuntimeContext().getServices();
        ArrayList<NakedObjectActionSet> relatedActions = new ArrayList<NakedObjectActionSet>();
        for (NakedObject serviceAdapter : services) {
            NakedObjectAction[] serviceActions = serviceAdapter.getSpecification().getObjectActions(type);
            ArrayList<NakedObjectAction> matchingActions = new ArrayList<NakedObjectAction>();
            for (int j = 0; j < serviceActions.length; ++j) {
                NakedObjectSpecification returnType = serviceActions[j].getReturnType();
                if (returnType != null && returnType.isCollection()) {
                    TypeOfFacet facet = returnType.getFacet(TypeOfFacet.class);
                    NakedObjectSpecification elementType = facet.valueSpec();
                    if (!elementType.isOfType(this)) continue;
                    matchingActions.add(serviceActions[j]);
                    continue;
                }
                if (returnType == null || !returnType.isOfType(this)) continue;
                matchingActions.add(serviceActions[j]);
            }
            if (matchingActions.size() <= 0) continue;
            NakedObjectActionSet set = new NakedObjectActionSet("id", serviceAdapter.titleString(), matchingActions, this.runtimeContext);
            relatedActions.add(set);
        }
        return relatedActions.toArray(new NakedObjectAction[relatedActions.size()]);
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isService() {
        return false;
    }

    @Override
    public boolean isDirty(NakedObject object) {
        return false;
    }

    @Override
    public void clearDirty(NakedObject object) {
    }

    @Override
    public void markDirty(NakedObject object) {
    }

    protected NakedObjectAction[] getServiceActions(NakedObjectActionType type) {
        if (this.isService()) {
            return new NakedObjectAction[0];
        }
        List<NakedObject> services = this.getRuntimeContext().getServices();
        ArrayList<NakedObjectActionSet> serviceActionSets = new ArrayList<NakedObjectActionSet>();
        for (NakedObject serviceAdapter : services) {
            NakedObjectSpecification specification = serviceAdapter.getSpecification();
            if (specification == this) continue;
            NakedObjectAction[] serviceActions = specification.getObjectActions(type);
            ArrayList<NakedObjectAction> matchingServiceActions = new ArrayList<NakedObjectAction>();
            for (int j = 0; j < serviceActions.length; ++j) {
                NakedObjectAction serviceAction = serviceActions[j];
                if (serviceAction.containsFacet(HiddenFacet.class) || !this.matchesParameterOf(serviceAction)) continue;
                matchingServiceActions.add(serviceAction);
            }
            if (matchingServiceActions.size() <= 0) continue;
            NakedObjectAction[] asArray = matchingServiceActions.toArray(new NakedObjectAction[matchingServiceActions.size()]);
            NakedObjectActionSet nakedObjectActionSet = new NakedObjectActionSet("id", serviceAdapter.titleString(), asArray, this.runtimeContext);
            serviceActionSets.add(nakedObjectActionSet);
        }
        return serviceActionSets.toArray(new NakedObjectAction[0]);
    }

    private boolean matchesParameterOf(NakedObjectAction serviceAction) {
        NakedObjectActionParameter[] params = serviceAction.getParameters();
        for (int k = 0; k < params.length; ++k) {
            if (!this.isOfType(params[k].getSpecification())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Consent isValid(NakedObject inObject) {
        return this.isValidResult(inObject).createConsent();
    }

    @Override
    public InteractionResult isValidResult(NakedObject targetNakedObject) {
        ObjectValidityContext validityContext = this.createValidityInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, targetNakedObject);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    @Override
    public ObjectValidityContext createValidityInteractionContext(AuthenticationSession session, InteractionInvocationMethod interactionMethod, NakedObject targetNakedObject) {
        return new ObjectValidityContext(session, interactionMethod, targetNakedObject, this.getIdentifier());
    }

    @Override
    public Persistability persistability() {
        return Persistability.USER_PERSISTABLE;
    }

    @Override
    public boolean isParseable() {
        return this.containsFacet(ParseableFacet.class);
    }

    @Override
    public boolean isEncodeable() {
        return this.containsFacet(EncodeableFacet.class);
    }

    @Override
    public boolean isValueOrIsAggregated() {
        return this.containsFacet(AggregatedFacet.class) || this.containsFacet(ValueFacet.class);
    }

    @Override
    public boolean isCollection() {
        return this.containsFacet(CollectionFacet.class);
    }

    @Override
    public boolean isObject() {
        return !this.isCollection();
    }

    @Override
    public boolean isImmutable() {
        return this.containsFacet(ImmutableFacet.class);
    }

    @Override
    public boolean isCollectionOrIsAggregated() {
        return false;
    }

    @Override
    public Object createObject(NakedObjectSpecification.CreationMode creationMode) {
        throw new UnsupportedOperationException(this.getFullName());
    }

    public String toString() {
        ToString str = new ToString(this);
        str.append("class", this.fullName);
        return str.toString();
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    protected final AuthenticationSession getAuthenticationSession() {
        return this.getRuntimeContext().getAuthenticationSession();
    }
}

