/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.runtimecontext.spec.feature;

import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.filters.Filter;
import org.nakedobjects.metamodel.commons.names.NameConvertorUtils;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.InteractionInvocationMethod;
import org.nakedobjects.metamodel.consent.InteractionResult;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.MultiTypedFacet;
import org.nakedobjects.metamodel.facets.help.HelpFacet;
import org.nakedobjects.metamodel.facets.naming.describedas.DescribedAsFacet;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacet;
import org.nakedobjects.metamodel.interactions.InteractionUtils;
import org.nakedobjects.metamodel.interactions.UsabilityContext;
import org.nakedobjects.metamodel.interactions.VisibilityContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.spec.feature.NakedObjectMember;
import org.nakedobjects.metamodel.spec.identifier.Identified;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NakedObjectMemberAbstract
implements NakedObjectMember {
    protected final String defaultName;
    private final String id;
    private final Identified facetHolder;
    private final MemberType memberType;
    private RuntimeContext runtimeContext;

    protected NakedObjectMemberAbstract(String id, Identified facetHolder, MemberType memberType, RuntimeContext runtimeContext) {
        if (id == null) {
            throw new IllegalArgumentException("Name must always be set");
        }
        this.id = id;
        this.defaultName = NameConvertorUtils.naturalName(id);
        this.facetHolder = facetHolder;
        this.memberType = memberType;
        this.runtimeContext = runtimeContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Identifier getIdentifier() {
        return this.facetHolder.getIdentifier();
    }

    public String toString() {
        return String.format("id=%s,name='%s'", this.getId(), this.getName());
    }

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        return this.facetHolder.containsFacet(facetType);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> cls) {
        return this.facetHolder.getFacet(cls);
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return this.facetHolder.getFacetTypes();
    }

    @Override
    public Facet[] getFacets(Filter<Facet> filter) {
        return this.facetHolder.getFacets(filter);
    }

    @Override
    public void addFacet(Facet facet) {
        this.facetHolder.addFacet(facet);
    }

    @Override
    public void addFacet(MultiTypedFacet facet) {
        this.facetHolder.addFacet(facet);
    }

    @Override
    public void removeFacet(Facet facet) {
        this.facetHolder.removeFacet(facet);
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        this.facetHolder.removeFacet(facetType);
    }

    @Override
    public String getName() {
        NamedFacet facet = this.getFacet(NamedFacet.class);
        String name = facet.value();
        name = name == null ? this.defaultName : name;
        return name;
    }

    @Override
    public String getDescription() {
        DescribedAsFacet facet = this.getFacet(DescribedAsFacet.class);
        return facet.value();
    }

    @Override
    public String getHelp() {
        HelpFacet facet = this.getFacet(HelpFacet.class);
        return facet.value();
    }

    @Override
    public Consent isVisible(AuthenticationSession session, NakedObject target) {
        return this.isVisibleResult(session, target).createConsent();
    }

    private InteractionResult isVisibleResult(AuthenticationSession session, NakedObject target) {
        VisibilityContext<?> ic = this.createVisibleInteractionContext(session, InteractionInvocationMethod.BY_USER, target);
        return InteractionUtils.isVisibleResult(this, ic);
    }

    @Override
    public Consent isUsable(AuthenticationSession session, NakedObject target) {
        return this.isUsableResult(session, target).createConsent();
    }

    private InteractionResult isUsableResult(AuthenticationSession session, NakedObject target) {
        UsabilityContext<?> ic = this.createUsableInteractionContext(session, InteractionInvocationMethod.BY_USER, target);
        return InteractionUtils.isUsableResult(this, ic);
    }

    @Override
    public boolean isAction() {
        return this.memberType.isAction();
    }

    @Override
    public boolean isAssociation() {
        return this.memberType.isAssociation();
    }

    @Override
    public boolean isOneToManyAssociation() {
        return this.memberType.isOneToManyAssociation();
    }

    @Override
    public boolean isOneToOneAssociation() {
        return this.memberType.isOneToOneAssociation();
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.getRuntimeContext().getAuthenticationSession();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MemberType {
        ONE_TO_ONE_ASSOCIATION,
        ONE_TO_MANY_ASSOCIATION,
        ACTION;


        public boolean isAction() {
            return this == ACTION;
        }

        public boolean isAssociation() {
            return !this.isAction();
        }

        public boolean isOneToManyAssociation() {
            return this == ONE_TO_MANY_ASSOCIATION;
        }

        public boolean isOneToOneAssociation() {
            return this == ONE_TO_ONE_ASSOCIATION;
        }
    }
}

