/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.services.container;

import java.util.ArrayList;
import java.util.List;
import org.nakedobjects.applib.DomainObjectContainer;
import org.nakedobjects.applib.Filter;
import org.nakedobjects.applib.PersistFailedException;
import org.nakedobjects.applib.RepositoryException;
import org.nakedobjects.applib.query.Query;
import org.nakedobjects.applib.security.RoleMemento;
import org.nakedobjects.applib.security.UserMemento;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.consent.InteractionResult;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContextAware;
import org.nakedobjects.metamodel.services.container.query.QueryFindAllInstances;
import org.nakedobjects.metamodel.services.container.query.QueryFindByPattern;
import org.nakedobjects.metamodel.services.container.query.QueryFindByTitle;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.util.NakedObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainObjectContainerDefault
implements DomainObjectContainer,
RuntimeContextAware {
    private RuntimeContext runtimeContext;

    public <T> T newTransientInstance(Class<T> ofClass) {
        NakedObjectSpecification spec = this.getRuntimeContext().getSpecificationLoader().loadSpecification(ofClass);
        NakedObject adapter = this.doCreateTransientInstance(spec);
        return (T)adapter.getObject();
    }

    public <T> T newPersistentInstance(Class<T> ofClass) {
        T newInstance = this.newTransientInstance(ofClass);
        this.persist(newInstance);
        return newInstance;
    }

    public <T> T newInstance(Class<T> ofClass, Object object) {
        if (this.isPersistent(object)) {
            return this.newPersistentInstance(ofClass);
        }
        return this.newTransientInstance(ofClass);
    }

    protected NakedObject doCreateTransientInstance(NakedObjectSpecification spec) {
        return this.getRuntimeContext().createTransientInstance(spec);
    }

    public void remove(Object persistentObject) {
        if (persistentObject == null) {
            throw new IllegalArgumentException("Must specify a reference for disposing an object");
        }
        NakedObject adapter = this.getRuntimeContext().getAdapterFor(persistentObject);
        if (!this.isPersistent(persistentObject)) {
            throw new RepositoryException("Object not persistent: " + adapter);
        }
        this.getRuntimeContext().remove(adapter);
    }

    public void resolve(Object parent) {
        this.runtimeContext.resolve(parent);
    }

    public void resolve(Object parent, Object field) {
        this.runtimeContext.resolve(parent, field);
    }

    public void objectChanged(Object object) {
        this.runtimeContext.objectChanged(object);
    }

    public boolean flush() {
        return this.runtimeContext.flush();
    }

    public void commit() {
        this.runtimeContext.commit();
    }

    public boolean isValid(Object domainObject) {
        return this.validate(domainObject) == null;
    }

    public String validate(Object domainObject) {
        NakedObject adapter = this.getRuntimeContext().adapterFor(domainObject);
        InteractionResult validityResult = adapter.getSpecification().isValidResult(adapter);
        return validityResult.getReason();
    }

    public boolean isPersistent(Object domainObject) {
        NakedObject adapter = this.getRuntimeContext().adapterFor(domainObject);
        return adapter.isPersistent();
    }

    public void persist(Object transientObject) {
        NakedObject adapter = this.getRuntimeContext().getAdapterFor(transientObject);
        if (this.isPersistent(transientObject)) {
            throw new PersistFailedException("Object already persistent: " + adapter);
        }
        this.getRuntimeContext().makePersistent(adapter);
    }

    public void persistIfNotAlready(Object object) {
        if (!this.isPersistent(object)) {
            this.persist(object);
        }
    }

    public UserMemento getUser() {
        AuthenticationSession session = this.getRuntimeContext().getAuthenticationSession();
        String name = session.getUserName();
        RoleMemento[] roleMementos = this.asRoleMementos(session.getRoles());
        UserMemento user = new UserMemento(name, roleMementos);
        return user;
    }

    private RoleMemento[] asRoleMementos(String[] roles) {
        ArrayList<RoleMemento> mementos = new ArrayList<RoleMemento>();
        if (roles != null) {
            for (String role : roles) {
                mementos.add(new RoleMemento(role));
            }
        }
        return mementos.toArray(new RoleMemento[0]);
    }

    public void informUser(String message) {
        this.getRuntimeContext().informUser(message);
    }

    public void raiseError(String message) {
        this.getRuntimeContext().raiseError(message);
    }

    public void warnUser(String message) {
        this.getRuntimeContext().warnUser(message);
    }

    public <T> List<T> allInstances(Class<T> type) {
        return this.allMatches((Query<T>)new QueryFindAllInstances<T>(type));
    }

    public <T> List<T> allMatches(Class<T> cls, Filter<T> filter) {
        List<T> allInstances = this.allInstances(cls);
        ArrayList<T> filtered = new ArrayList<T>();
        for (T instance : allInstances) {
            if (!filter.accept(instance)) continue;
            filtered.add(instance);
        }
        return filtered;
    }

    public <T> List<T> allMatches(Class<T> type, T pattern) {
        Assert.assertTrue("pattern not compatible with type", type.isAssignableFrom(pattern.getClass()));
        return this.allMatches((Query<T>)new QueryFindByPattern<T>(type, pattern));
    }

    public <T> List<T> allMatches(Class<T> type, String title) {
        return this.allMatches((Query<T>)new QueryFindByTitle<T>(type, title));
    }

    public <T> List<T> allMatches(Query<T> query) {
        List<NakedObject> allMatching = this.getRuntimeContext().allMatchingQuery(query);
        return NakedObjectUtils.unwrap(allMatching);
    }

    public <T> T firstMatch(Class<T> cls, Filter<T> filter) {
        List<T> allInstances = this.allInstances(cls);
        for (T instance : allInstances) {
            if (!filter.accept(instance)) continue;
            return instance;
        }
        return null;
    }

    public <T> T firstMatch(Class<T> type, T pattern) {
        List<T> instances = this.allMatches(type, pattern);
        return this.firstInstanceElseNull(instances);
    }

    public <T> T firstMatch(Class<T> type, String title) {
        List<T> instances = this.allMatches(type, title);
        return this.firstInstanceElseNull(instances);
    }

    public <T> T firstMatch(Query<T> query) {
        NakedObject firstMatching = this.getRuntimeContext().firstMatchingQuery(query);
        return (T)NakedObjectUtils.unwrap(firstMatching);
    }

    public <T> T uniqueMatch(Class<T> type, Filter<T> filter) {
        List<Filter<T>> instances = this.allMatches(type, (T)filter);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more than one instance of " + type + " matching filter " + filter);
        }
        return (T)this.firstInstanceElseNull(instances);
    }

    public <T> T uniqueMatch(Class<T> type, T pattern) {
        List<T> instances = this.allMatches(type, pattern);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance of " + type + " matching pattern " + pattern);
        }
        return this.firstInstanceElseNull(instances);
    }

    public <T> T uniqueMatch(Class<T> type, String title) {
        List<T> instances = this.allMatches(type, title);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance of " + type + " with title " + title);
        }
        return this.firstInstanceElseNull(instances);
    }

    public <T> T uniqueMatch(Query<T> query) {
        List<T> instances = this.allMatches(query);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance for query:" + query.getDescription());
        }
        return this.firstInstanceElseNull(instances);
    }

    private <T> T firstInstanceElseNull(List<T> instances) {
        return instances.size() == 0 ? null : (T)instances.get(0);
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
        runtimeContext.setContainer(this);
    }
}

