/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.spec.identifier;

import java.util.StringTokenizer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;

public class IdentifierFactory {
    private IdentifierFactory() {
    }

    public static Identifier fromIdentityString(String asString) {
        Ensure.ensureThatArg(asString, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        int indexOfHash = asString.indexOf("#");
        int indexOfOpenBracket = asString.indexOf("(");
        int indexOfCloseBracket = asString.indexOf(")");
        String className = asString.substring(0, indexOfHash == -1 ? asString.length() : indexOfHash);
        if (indexOfHash == -1 || indexOfHash == asString.length() - 1) {
            return Identifier.classIdentifier((String)className);
        }
        String name = null;
        if (indexOfOpenBracket == -1) {
            name = asString.substring(indexOfHash + 1);
            return Identifier.propertyOrCollectionIdentifier((String)className, (String)name);
        }
        String[] parms = null;
        name = asString.substring(indexOfHash + 1, indexOfOpenBracket);
        String allParms = asString.substring(indexOfOpenBracket + 1, indexOfCloseBracket).trim();
        if (allParms.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(allParms, ",", false);
            parms = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                parms[i] = tokens.nextToken();
                ++i;
            }
        }
        return Identifier.actionIdentifier((String)className, (String)name, parms);
    }

    private static String[] toParameterStringArray(NakedObjectSpecification[] specifications) {
        String[] parameters = new String[specifications == null ? 0 : specifications.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = specifications[i].getFullName();
        }
        return parameters;
    }

    public static Identifier create(String className, String methodName, NakedObjectSpecification[] specifications) {
        return Identifier.actionIdentifier((String)className, (String)methodName, (String[])IdentifierFactory.toParameterStringArray(specifications));
    }
}

