/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.specloader.internal;

import org.nakedobjects.metamodel.adapter.Instance;
import org.nakedobjects.metamodel.adapter.MutableProposedHolder;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.consent.InteractionInvocationMethod;
import org.nakedobjects.metamodel.consent.InteractionResultSet;
import org.nakedobjects.metamodel.facets.object.parseable.ParseableFacet;
import org.nakedobjects.metamodel.facets.propparam.multiline.MultiLineFacet;
import org.nakedobjects.metamodel.facets.propparam.typicallength.TypicalLengthFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.maxlength.MaxLengthFacet;
import org.nakedobjects.metamodel.interactions.ActionArgumentContext;
import org.nakedobjects.metamodel.interactions.InteractionUtils;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionParameter;
import org.nakedobjects.metamodel.spec.feature.ParseableEntryActionParameter;
import org.nakedobjects.metamodel.specloader.internal.NakedObjectActionImpl;
import org.nakedobjects.metamodel.specloader.internal.NakedObjectActionParameterAbstract;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectActionParamPeer;

public class NakedObjectActionParameterParseable
extends NakedObjectActionParameterAbstract
implements ParseableEntryActionParameter {
    public NakedObjectActionParameterParseable(int index, NakedObjectActionImpl action, NakedObjectActionParamPeer peer) {
        super(index, action, peer);
    }

    public int getNoLines() {
        MultiLineFacet facet = this.getFacet(MultiLineFacet.class);
        return facet.numberOfLines();
    }

    public boolean canWrap() {
        MultiLineFacet facet = this.getFacet(MultiLineFacet.class);
        return !facet.preventWrapping();
    }

    public int getMaximumLength() {
        MaxLengthFacet facet = this.getFacet(MaxLengthFacet.class);
        return facet.value();
    }

    public int getTypicalLineLength() {
        TypicalLengthFacet facet = this.getFacet(TypicalLengthFacet.class);
        return facet.value();
    }

    public String isValid(NakedObject nakedObject, Object proposedValue) {
        if (!(proposedValue instanceof String)) {
            return null;
        }
        String proposedString = (String)proposedValue;
        NakedObjectActionParameter nakedObjectActionParameter = this.getAction().getParameters()[this.getNumber()];
        if (!(nakedObjectActionParameter instanceof ParseableEntryActionParameter)) {
            return null;
        }
        ParseableEntryActionParameter parameter = (ParseableEntryActionParameter)nakedObjectActionParameter;
        NakedObjectSpecification parameterSpecification = parameter.getSpecification();
        ParseableFacet p = parameterSpecification.getFacet(ParseableFacet.class);
        NakedObject newValue = p.parseTextEntry(null, proposedString);
        ActionArgumentContext ic = parameter.createProposedArgumentInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, nakedObject, this.arguments(newValue), this.getNumber());
        InteractionResultSet buf = new InteractionResultSet();
        InteractionUtils.isValidResultSet(parameter, ic, buf);
        if (buf.isVetoed()) {
            return buf.getInteractionResult().getReason();
        }
        return null;
    }

    private NakedObject[] arguments(NakedObject proposedValue) {
        int parameterCount = this.getAction().getParameterCount();
        NakedObject[] arguments = new NakedObject[parameterCount];
        arguments[this.getNumber()] = proposedValue;
        return arguments;
    }

    public Instance getInstance(NakedObject nakedObject) {
        NakedObjectActionParameterParseable specification = this;
        return nakedObject.getInstance(specification);
    }

    public NakedObject get(NakedObject owner) {
        MutableProposedHolder proposedHolder = this.getProposedHolder(owner);
        Object proposed = proposedHolder.getProposed();
        return this.getRuntimeContext().adapterFor(proposed);
    }

    public void set(NakedObject owner, NakedObject newValue) {
        MutableProposedHolder proposedHolder = this.getProposedHolder(owner);
        Object newValuePojo = newValue.getObject();
        proposedHolder.setProposed(newValuePojo);
    }

    private MutableProposedHolder getProposedHolder(NakedObject owner) {
        Instance instance = this.getInstance(owner);
        if (!(instance instanceof MutableProposedHolder)) {
            throw new IllegalArgumentException("Instance should implement MutableProposedHolder");
        }
        MutableProposedHolder proposedHolder = (MutableProposedHolder)((Object)instance);
        return proposedHolder;
    }
}

