/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.specloader.internal;

import java.util.List;
import org.nakedobjects.metamodel.adapter.Instance;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.InteractionInvocationMethod;
import org.nakedobjects.metamodel.consent.InteractionResult;
import org.nakedobjects.metamodel.facets.propcoll.access.PropertyAccessorFacet;
import org.nakedobjects.metamodel.facets.properties.choices.PropertyChoicesFacet;
import org.nakedobjects.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyClearFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyInitializationFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertySetterFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.mandatory.MandatoryFacet;
import org.nakedobjects.metamodel.interactions.InteractionUtils;
import org.nakedobjects.metamodel.interactions.PropertyAccessContext;
import org.nakedobjects.metamodel.interactions.PropertyModifyContext;
import org.nakedobjects.metamodel.interactions.PropertyUsabilityContext;
import org.nakedobjects.metamodel.interactions.PropertyVisibilityContext;
import org.nakedobjects.metamodel.interactions.UsabilityContext;
import org.nakedobjects.metamodel.interactions.ValidityContext;
import org.nakedobjects.metamodel.interactions.VisibilityContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.spec.feature.NakedObjectAssociationAbstract;
import org.nakedobjects.metamodel.runtimecontext.spec.feature.NakedObjectMemberAbstract;
import org.nakedobjects.metamodel.services.container.query.QueryFindAllInstances;
import org.nakedobjects.metamodel.spec.SpecificationFacets;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectAssociationPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToOneAssociationImpl
extends NakedObjectAssociationAbstract
implements OneToOneAssociation {
    private final NakedObjectAssociationPeer associationPeer;

    public OneToOneAssociationImpl(NakedObjectAssociationPeer association, RuntimeContext runtimeContext) {
        super(association.getIdentifier().getMemberName(), association.getSpecification(), NakedObjectMemberAbstract.MemberType.ONE_TO_ONE_ASSOCIATION, association, runtimeContext);
        this.associationPeer = association;
    }

    @Override
    public VisibilityContext<?> createVisibleInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, NakedObject ownerAdapter) {
        return new PropertyVisibilityContext(session, invocationMethod, ownerAdapter, this.getIdentifier());
    }

    @Override
    public UsabilityContext<?> createUsableInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, NakedObject ownerAdapter) {
        return new PropertyUsabilityContext(session, invocationMethod, ownerAdapter, this.getIdentifier());
    }

    @Override
    public ValidityContext<?> createValidateInteractionContext(AuthenticationSession session, InteractionInvocationMethod interactionMethod, NakedObject ownerAdapter, NakedObject proposedToReferenceAdapter) {
        return new PropertyModifyContext(session, interactionMethod, ownerAdapter, this.getIdentifier(), proposedToReferenceAdapter);
    }

    @Override
    public Consent isAssociationValid(NakedObject ownerAdapter, NakedObject proposedToReferenceAdapter) {
        return this.isAssociationValidResult(ownerAdapter, proposedToReferenceAdapter).createConsent();
    }

    private InteractionResult isAssociationValidResult(NakedObject ownerAdapter, NakedObject proposedToReferenceAdapter) {
        ValidityContext<?> validityContext = this.createValidateInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, ownerAdapter, proposedToReferenceAdapter);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    @Override
    public void initAssociation(NakedObject ownerAdapter, NakedObject referencedAdapter) {
        PropertyInitializationFacet initializerFacet = this.getFacet(PropertyInitializationFacet.class);
        if (initializerFacet != null) {
            initializerFacet.initProperty(ownerAdapter, referencedAdapter);
        }
    }

    @Override
    public NakedObject get(NakedObject ownerAdapter) {
        PropertyAccessorFacet facet = this.getFacet(PropertyAccessorFacet.class);
        Object referencedPojo = facet.getProperty(ownerAdapter);
        if (referencedPojo == null) {
            return null;
        }
        return this.getRuntimeContext().adapterFor(referencedPojo, ownerAdapter, this);
    }

    @Override
    public PropertyAccessContext createAccessInteractionContext(AuthenticationSession session, InteractionInvocationMethod interactionMethod, NakedObject ownerAdapter) {
        return new PropertyAccessContext(session, InteractionInvocationMethod.BY_USER, ownerAdapter, this.getIdentifier(), this.get(ownerAdapter));
    }

    @Override
    public boolean isEmpty(NakedObject ownerAdapter) {
        return this.get(ownerAdapter) == null;
    }

    @Override
    public void set(NakedObject ownerAdapter, NakedObject newReferencedAdapter) {
        if (newReferencedAdapter != null) {
            this.setAssociation(ownerAdapter, newReferencedAdapter);
        } else {
            this.clearAssociation(ownerAdapter);
        }
    }

    @Override
    public void setAssociation(NakedObject ownerAdapter, NakedObject newReferencedAdapter) {
        PropertySetterFacet setterFacet = this.getFacet(PropertySetterFacet.class);
        if (setterFacet != null) {
            if (ownerAdapter.isPersistent() && newReferencedAdapter != null && newReferencedAdapter.isTransient()) {
                throw new NakedObjectException("can't set a reference to a transient object from a persistent one: " + newReferencedAdapter.titleString() + " (transient)");
            }
            setterFacet.setProperty(ownerAdapter, newReferencedAdapter);
        }
    }

    @Override
    public void clearAssociation(NakedObject ownerAdapter) {
        PropertyClearFacet facet = this.getFacet(PropertyClearFacet.class);
        facet.clearProperty(ownerAdapter);
    }

    @Override
    public NakedObject getDefault(NakedObject ownerAdapter) {
        PropertyDefaultFacet propertyDefaultFacet = this.getFacet(PropertyDefaultFacet.class);
        if (propertyDefaultFacet == null || propertyDefaultFacet.isNoop()) {
            propertyDefaultFacet = this.getSpecification().getFacet(PropertyDefaultFacet.class);
        }
        if (propertyDefaultFacet == null) {
            return null;
        }
        return propertyDefaultFacet.getDefault(ownerAdapter);
    }

    @Override
    public void toDefault(NakedObject ownerAdapter) {
        MandatoryFacet mandatoryFacet = this.getFacet(MandatoryFacet.class);
        if (mandatoryFacet != null && mandatoryFacet.isInvertedSemantics()) {
            return;
        }
        NakedObject defaultValue = this.getDefault(ownerAdapter);
        if (defaultValue != null) {
            this.initAssociation(ownerAdapter, defaultValue);
        }
    }

    @Override
    public boolean hasChoices() {
        PropertyChoicesFacet propertyChoicesFacet = this.getFacet(PropertyChoicesFacet.class);
        boolean optionEnabled = propertyChoicesFacet != null;
        return SpecificationFacets.isBoundedSet(this.getSpecification()) || optionEnabled;
    }

    @Override
    public NakedObject[] getChoices(NakedObject ownerAdapter) {
        Object[] pojoOptions;
        PropertyChoicesFacet propertyChoicesFacet = this.getFacet(PropertyChoicesFacet.class);
        Object[] objectArray = pojoOptions = propertyChoicesFacet == null ? null : propertyChoicesFacet.getChoices(ownerAdapter);
        if (pojoOptions != null) {
            NakedObject[] options = new NakedObject[pojoOptions.length];
            for (int i = 0; i < options.length; ++i) {
                options[i] = this.getRuntimeContext().adapterFor(pojoOptions[i]);
            }
            return options;
        }
        if (SpecificationFacets.isBoundedSet(this.getSpecification())) {
            QueryFindAllInstances query = new QueryFindAllInstances(this.getSpecification());
            List<NakedObject> allInstancesAdapter = this.getRuntimeContext().allMatchingQuery(query);
            NakedObject[] options = new NakedObject[allInstancesAdapter.size()];
            int j = 0;
            for (NakedObject adapter : allInstancesAdapter) {
                options[j++] = adapter;
            }
            return options;
        }
        return null;
    }

    @Override
    public Instance getInstance(NakedObject ownerAdapter) {
        OneToOneAssociationImpl specification = this;
        return ownerAdapter.getInstance(specification);
    }

    @Override
    public String debugData() {
        DebugString debugString = new DebugString();
        debugString.indent();
        debugString.indent();
        this.associationPeer.debugData(debugString);
        return debugString.toString();
    }

    @Override
    public String toString() {
        ToString str = new ToString(this);
        str.append(super.toString());
        str.setAddComma();
        str.append("persisted", this.isNotDerived());
        str.append("type", this.getSpecification().getShortName());
        return str.toString();
    }
}

