/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.specloader.internal.peer;

import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.actions.debug.DebugFacet;
import org.nakedobjects.metamodel.facets.actions.executed.ExecutedFacet;
import org.nakedobjects.metamodel.facets.actions.exploration.ExplorationFacet;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.Target;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.metamodel.specloader.ReflectiveActionException;
import org.nakedobjects.metamodel.specloader.internal.peer.JavaNakedObjectActionParamPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.JavaNakedObjectMemberPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectActionParamPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectActionPeer;

public class JavaNakedObjectActionPeer
extends JavaNakedObjectMemberPeer
implements NakedObjectActionPeer {
    private final JavaNakedObjectActionParamPeer[] parameters;

    public JavaNakedObjectActionPeer(Identifier identifier, JavaNakedObjectActionParamPeer[] parameters) {
        super(identifier);
        this.parameters = parameters;
    }

    public Target getTarget() {
        ExecutedFacet executedFacet = this.getFacet(ExecutedFacet.class);
        return executedFacet == null ? NakedObjectActionConstants.DEFAULT : executedFacet.getTarget();
    }

    public NakedObjectActionType getType() {
        DebugFacet debugFacet = this.getFacet(DebugFacet.class);
        if (debugFacet != null) {
            return NakedObjectActionConstants.DEBUG;
        }
        ExplorationFacet explorationFacet = this.getFacet(ExplorationFacet.class);
        if (explorationFacet != null) {
            return NakedObjectActionConstants.EXPLORATION;
        }
        return NakedObjectActionConstants.USER;
    }

    public NakedObject execute(NakedObject inObject, NakedObject[] parameters) throws ReflectiveActionException {
        ActionInvocationFacet facet = this.getFacet(ActionInvocationFacet.class);
        return facet.invoke(inObject, parameters);
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    public NakedObjectActionParamPeer[] getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuffer parameters = new StringBuffer();
        ActionInvocationFacet facet = this.getFacet(ActionInvocationFacet.class);
        NakedObjectSpecification onType = facet.getOnType();
        return "JavaAction [name=" + this.getIdentifier().getMemberName() + ",type=" + onType.getShortName() + ",parameters=" + parameters + "]";
    }
}

