/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.util;

import java.util.ArrayList;
import java.util.List;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionFacetUtils {
    private CollectionFacetUtils() {
    }

    public static CollectionFacet getCollectionFacetFromSpec(NakedObject objectRepresentingCollection) {
        NakedObjectSpecification collectionSpec = objectRepresentingCollection.getSpecification();
        return collectionSpec.getFacet(CollectionFacet.class);
    }

    public static int size(NakedObject collection) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(collection);
        return facet.size(collection);
    }

    public static NakedObject firstElement(NakedObject collection) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(collection);
        return facet.firstElement(collection);
    }

    @Deprecated
    public static Object[] convertToArray(NakedObject collection) {
        return CollectionFacetUtils.convertToList(collection).toArray();
    }

    public static List<Object> convertToList(NakedObject collection) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(collection);
        ArrayList<Object> objects = new ArrayList<Object>();
        for (NakedObject adapter : facet.iterable(collection)) {
            objects.add(adapter.getObject());
        }
        return objects;
    }

    public static List<NakedObject> convertToAdapterList(NakedObject collection) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(collection);
        ArrayList<NakedObject> adapters = new ArrayList<NakedObject>();
        for (NakedObject adapter : facet.iterable(collection)) {
            adapters.add(adapter);
        }
        return adapters;
    }
}

