/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nakedobjects.applib.ApplicationException;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectApplicationException;
import org.nakedobjects.metamodel.exceptions.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeUtils {
    private static Map<Class<?>, Object> defaultByPrimitiveType = new HashMap();

    public static void invoke(List<Method> methods, Object object) {
        for (Method method : methods) {
            InvokeUtils.invoke(method, object);
        }
    }

    public static Object invoke(Method method, Object object) {
        Object[] parameters = InvokeUtils.nullOrDefaultArgsFor(method);
        return InvokeUtils.invoke(method, object, parameters);
    }

    public static Object invoke(Method method, Object object, Object[] parameters) {
        try {
            return method.invoke(object, parameters);
        }
        catch (InvocationTargetException e) {
            InvokeUtils.invocationException("Exception executing " + method, e);
            return null;
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException("illegal access of " + method, e);
        }
    }

    public static Object invokeStatic(Method method, Object[] parameters) {
        return InvokeUtils.invoke(method, null, parameters);
    }

    public static Object invokeStatic(Method method) {
        return InvokeUtils.invoke(method, null, InvokeUtils.nullOrDefaultArgsFor(method));
    }

    public static void invocationException(String error, InvocationTargetException e) {
        Throwable targetException = e.getTargetException();
        if (targetException instanceof ApplicationException) {
            throw new NakedObjectApplicationException(targetException);
        }
        if (targetException instanceof RuntimeException) {
            throw (RuntimeException)targetException;
        }
        throw new ReflectionException(targetException);
    }

    private static Object[] nullOrDefaultArgsFor(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] parameters = new Object[paramTypes.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = InvokeUtils.nullOrDefaultFor(paramTypes[i]);
        }
        return parameters;
    }

    private static Object nullOrDefaultFor(Class<?> type) {
        return defaultByPrimitiveType.get(type);
    }

    static {
        defaultByPrimitiveType.put(Byte.TYPE, (byte)0);
        defaultByPrimitiveType.put(Short.TYPE, (short)0);
        defaultByPrimitiveType.put(Integer.TYPE, 0);
        defaultByPrimitiveType.put(Long.TYPE, 0L);
        defaultByPrimitiveType.put(Character.TYPE, 0);
        defaultByPrimitiveType.put(Float.TYPE, Float.valueOf(0.0f));
        defaultByPrimitiveType.put(Double.TYPE, 0.0);
        defaultByPrimitiveType.put(Boolean.TYPE, false);
    }
}

