/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.value.BigIntegerValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerValueSemanticsProvider
extends ValueSemanticsProviderAbstract
implements BigIntegerValueFacet {
    private static final int TYPICAL_LENGTH = 19;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private static final Object DEFAULT_VALUE = BigInteger.valueOf(0L);
    private final NumberFormat format = this.determineNumberFormat("value.format.int");

    private static Class<? extends Facet> type() {
        return BigIntegerValueFacet.class;
    }

    public BigIntegerValueSemanticsProvider() {
        this(null, null, null, null);
    }

    public BigIntegerValueSemanticsProvider(FacetHolder holder, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(BigIntegerValueSemanticsProvider.type(), holder, BigInteger.class, 19, true, true, DEFAULT_VALUE, configuration, specificationLoader, runtimeContext);
    }

    @Override
    protected Object doParse(Object original, String entry) {
        try {
            return new BigInteger(entry);
        }
        catch (NumberFormatException e) {
            throw new TextEntryParseException("Not an integer " + entry, e);
        }
    }

    @Override
    public String titleString(Object object) {
        return this.titleString(this.format, object);
    }

    public String titleWithMask(String mask, Object value) {
        return this.titleString(new DecimalFormat(mask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Object doRestore(String data) {
        return new BigInteger(data);
    }

    @Override
    public String toString() {
        return "BigIntegerValueSemanticsProvider: " + this.format;
    }
}

