/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.nakedobjects.applib.value.Color;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.value.ColorValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorValueSemanticsProvider
extends ValueSemanticsProviderAbstract
implements ColorValueFacet {
    private static final int TYPICAL_LENGTH = 4;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = false;
    private static final Object DEFAULT_VALUE = Color.BLACK;

    public static Class<? extends Facet> type() {
        return ColorValueFacet.class;
    }

    public ColorValueSemanticsProvider() {
        this(null, null, null, null);
    }

    public ColorValueSemanticsProvider(FacetHolder holder, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(ColorValueSemanticsProvider.type(), holder, Color.class, 4, true, false, DEFAULT_VALUE, configuration, specificationLoader, runtimeContext);
    }

    @Override
    protected Object doParse(Object original, String text) {
        try {
            if (text.startsWith("0x")) {
                return new Color(Integer.parseInt(text.substring(2), 16));
            }
            if (text.startsWith("#")) {
                return new Color(Integer.parseInt(text.substring(1), 16));
            }
            return new Color(Integer.parseInt(text));
        }
        catch (NumberFormatException e) {
            throw new TextEntryParseException("Not a number " + text, e);
        }
    }

    @Override
    public String titleString(Object object) {
        Color color = (Color)object;
        return color.title();
    }

    @Override
    protected String doEncode(Object object) {
        Color color = (Color)object;
        return Integer.toHexString(color.intValue());
    }

    @Override
    protected Object doRestore(String data) {
        return new Color(Integer.parseInt(data, 16));
    }

    @Override
    public int colorValue(NakedObject object) {
        if (object == null) {
            return 0;
        }
        Color color = (Color)object.getObject();
        return color.intValue();
    }

    @Override
    public NakedObject createValue(NakedObject object, int colorAsInt) {
        Color color = new Color(colorAsInt);
        return this.getRuntimeContext().adapterFor(color);
    }

    @Override
    public String toString() {
        return "ColorValueSemanticsProvider";
    }
}

