/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.value.FloatingPointValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatValueSemanticsProviderAbstract
extends ValueSemanticsProviderAbstract
implements FloatingPointValueFacet {
    private static final int TYPICAL_LENGTH = 12;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private final NumberFormat format = this.determineNumberFormat("value.format.float");

    public static Class<? extends Facet> type() {
        return FloatingPointValueFacet.class;
    }

    public FloatValueSemanticsProviderAbstract(FacetHolder holder, Class<?> adaptedClass, Object defaultValue, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(FloatValueSemanticsProviderAbstract.type(), holder, adaptedClass, 12, true, true, defaultValue, configuration, specificationLoader, runtimeContext);
    }

    @Override
    protected Object doParse(Object original, String entry) {
        try {
            return new Float(this.format.parse(entry).floatValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not a floating point number " + entry, e);
        }
    }

    @Override
    public String titleString(Object value) {
        return this.titleString(this.format, value);
    }

    public String titleWithMask(String mask, Object value) {
        return this.titleString(new DecimalFormat(mask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Object doRestore(String data) {
        return new Float(data);
    }

    @Override
    public Float floatValue(NakedObject object) {
        return object == null ? null : (Float)object.getObject();
    }

    @Override
    public NakedObject createValue(Float value) {
        return this.getRuntimeContext().adapterFor(value);
    }

    @Override
    public String toString() {
        return "FloatValueSemanticsProvider: " + this.format;
    }
}

