/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.value.LongValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LongValueSemanticsProviderAbstract
extends ValueSemanticsProviderAbstract
implements LongValueFacet {
    private static final int TYPICAL_LENGTH = 18;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private NumberFormat format = this.determineNumberFormat("value.format.long");

    public static Class<? extends Facet> type() {
        return LongValueFacet.class;
    }

    public LongValueSemanticsProviderAbstract(FacetHolder holder, Class<?> adaptedClass, Object defaultValue, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(LongValueSemanticsProviderAbstract.type(), holder, adaptedClass, 18, true, true, defaultValue, configuration, specificationLoader, runtimeContext);
    }

    @Override
    protected Object doParse(Object original, String entry) {
        try {
            return new Long(this.format.parse(entry).longValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not a whole number " + entry, e);
        }
    }

    @Override
    public String titleString(Object value) {
        return this.titleString(this.format, value);
    }

    public String titleWithMask(String mask, Object value) {
        return this.titleString(new DecimalFormat(mask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Object doRestore(String data) {
        return new Long(data);
    }

    @Override
    public Long longValue(NakedObject object) {
        return (Long)(object == null ? null : object.getObject());
    }

    @Override
    public NakedObject createValue(Long value) {
        return value == null ? null : this.getRuntimeContext().adapterFor(value);
    }

    @Override
    public String toString() {
        return "LongValueSemanticsProvider: " + this.format;
    }
}

