/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.nakedobjects.applib.value.TimeStamp;
import org.nakedobjects.metamodel.adapter.InvalidEntryException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTemporal;

public class TimeStampValueSemanticsProvider
extends ValueSemanticsProviderAbstractTemporal {
    private static final Object DEFAULT_VALUE = null;
    private static Hashtable formats = new Hashtable();
    private static final int TYPICAL_LENGTH = 12;
    private static final boolean IMMUTABLE = false;
    private static final boolean EQUAL_BY_CONTENT = false;

    public static final boolean isAPropertyDefaultFacet() {
        return PropertyDefaultFacet.class.isAssignableFrom(TimeStampValueSemanticsProvider.class);
    }

    public TimeStampValueSemanticsProvider() {
        this(null, null, null, null);
    }

    public TimeStampValueSemanticsProvider(FacetHolder holder, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super("timestamp", holder, TimeStamp.class, 12, false, false, DEFAULT_VALUE, configuration, specificationLoader, runtimeContext);
        String formatRequired = configuration.getString("nakedobjects.value.format.timestamp");
        if (formatRequired == null) {
            this.format = (DateFormat)this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    public int getLevel() {
        return 273;
    }

    protected Object add(Object original, int years, int months, int days, int hours, int minutes) {
        return original;
    }

    protected Date dateValue(Object value) {
        return new Date(((TimeStamp)value).longValue());
    }

    protected String defaultFormat() {
        return "short";
    }

    protected Hashtable formats() {
        return formats;
    }

    protected Object now() {
        throw new InvalidEntryException("Can't change a timestamp.");
    }

    protected Object setDate(Date date) {
        return new TimeStamp(date.getTime());
    }

    public String toString() {
        return "TimeStampValueSemanticsProvider: " + this.format;
    }

    static {
        formats.put("iso", TimeStampValueSemanticsProvider.createDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        formats.put("iso_encoding", TimeStampValueSemanticsProvider.createDateFormat("yyyyMMdd'T'HHmmssSSS"));
        formats.put("medium", DateFormat.getDateTimeInstance(2, 1));
        formats.put("short", DateFormat.getDateTimeInstance(3, 1));
    }
}

