/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.nakedobjects.applib.adapters.EncodingException;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.value.DateValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueSemanticsProviderAbstractTemporal
extends ValueSemanticsProviderAbstract
implements DateValueFacet {
    protected static final String ISO_ENCODING_FORMAT = "iso_encoding";
    private static final TimeZone UTC_TIME_ZONE;
    private final DateFormat encodingFormat;
    protected DateFormat format;

    public static Class<? extends Facet> type() {
        return DateValueFacet.class;
    }

    protected static DateFormat createDateFormat(String mask) {
        return new SimpleDateFormat(mask);
    }

    public ValueSemanticsProviderAbstractTemporal(String propertyName, FacetHolder holder, Class<?> adaptedClass, int typicalLength, boolean immutable, boolean equalByContent, Object defaultValue, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        this(propertyName, ValueSemanticsProviderAbstractTemporal.type(), holder, adaptedClass, typicalLength, immutable, equalByContent, defaultValue, configuration, specificationLoader, runtimeContext);
    }

    public ValueSemanticsProviderAbstractTemporal(String propertyName, Class<? extends Facet> facetType, FacetHolder holder, Class<?> adaptedClass, int typicalLength, boolean immutable, boolean equalByContent, Object defaultValue, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(facetType, holder, adaptedClass, typicalLength, immutable, equalByContent, defaultValue, configuration, specificationLoader, runtimeContext);
        Hashtable formats = this.formats();
        Enumeration elements = formats.elements();
        while (elements.hasMoreElements()) {
            DateFormat format = (DateFormat)elements.nextElement();
            format.setLenient(false);
            if (!this.ignoreTimeZone()) continue;
            format.setTimeZone(UTC_TIME_ZONE);
        }
        String defaultFormat = configuration.getString("nakedobjects.value.format." + propertyName, this.defaultFormat());
        String required = defaultFormat.toLowerCase().trim();
        this.format = (DateFormat)formats.get(required);
        if (this.format == null) {
            this.setMask(defaultFormat);
        }
        this.encodingFormat = (DateFormat)formats.get(ISO_ENCODING_FORMAT);
    }

    @Override
    protected Object doParse(Object original, String entry) {
        String dateString = entry.trim();
        String str = dateString.toLowerCase();
        if (str.equals("today") || str.equals("now")) {
            return this.now();
        }
        if (dateString.startsWith("+")) {
            return this.relativeDate(original == null ? this.now() : original, dateString, true);
        }
        if (dateString.startsWith("-")) {
            return this.relativeDate(original == null ? this.now() : original, dateString, false);
        }
        return this.parseDate(dateString, original == null ? this.now() : original);
    }

    private Object parseDate(String dateString, Object original) {
        try {
            return this.setDate(this.format.parse(dateString));
        }
        catch (ParseException e) {
            Hashtable formats = this.formats();
            Enumeration elements = formats.elements();
            return this.setDate(this.parseDate(dateString, elements));
        }
    }

    private Date parseDate(String dateString, Enumeration elements) {
        DateFormat format = (DateFormat)elements.nextElement();
        try {
            return format.parse(dateString);
        }
        catch (ParseException e) {
            if (elements.hasMoreElements()) {
                return this.parseDate(dateString, elements);
            }
            throw new TextEntryParseException("Not recognised as a date: " + dateString);
        }
    }

    private Object relativeDate(Object original, String str, boolean add) {
        if (str.equals("")) {
            return this.now();
        }
        Object date = original;
        StringTokenizer st = new StringTokenizer(str.substring(1), " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            date = this.relativeDate2(date, token, add);
        }
        return date;
    }

    private Object relativeDate2(Object original, String str, boolean add) {
        int hours = 0;
        int minutes = 0;
        int days = 0;
        int months = 0;
        int years = 0;
        if (str.endsWith("H")) {
            str = str.substring(0, str.length() - 1);
            hours = Integer.valueOf(str);
        } else if (str.endsWith("M")) {
            str = str.substring(0, str.length() - 1);
            minutes = Integer.valueOf(str);
        } else if (str.endsWith("w")) {
            str = str.substring(0, str.length() - 1);
            days = 7 * Integer.valueOf(str);
        } else if (str.endsWith("y")) {
            str = str.substring(0, str.length() - 1);
            years = Integer.valueOf(str);
        } else if (str.endsWith("m")) {
            str = str.substring(0, str.length() - 1);
            months = Integer.valueOf(str);
        } else if (str.endsWith("d")) {
            str = str.substring(0, str.length() - 1);
            days = Integer.valueOf(str);
        } else {
            days = Integer.valueOf(str);
        }
        if (add) {
            return this.add(original, years, months, days, hours, minutes);
        }
        return this.add(original, -years, -months, -days, -hours, -minutes);
    }

    @Override
    public String titleString(Object value) {
        if (value == null) {
            return null;
        }
        Date date = this.dateValue(value);
        return this.titleString(this.format, date);
    }

    public String titleWithMask(String mask, Object value) {
        Date date = this.dateValue(value);
        return this.titleString(new SimpleDateFormat(mask), date);
    }

    private String titleString(DateFormat formatter, Date date) {
        return date == null ? "" : formatter.format(date);
    }

    @Override
    protected String doEncode(Object object) {
        Date date = this.dateValue(object);
        return this.encodingFormat.format(date);
    }

    @Override
    protected Object doRestore(String data) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.encodingFormat.parse(data));
            this.clearFields(cal);
            return this.setDate(cal.getTime());
        }
        catch (ParseException e) {
            throw new EncodingException((Throwable)e);
        }
    }

    @Override
    public final Date dateValue(NakedObject object) {
        return object == null ? null : this.dateValue(object.getObject());
    }

    @Override
    public final NakedObject createValue(Date date) {
        return this.getRuntimeContext().adapterFor(this.setDate(date));
    }

    @Override
    public abstract int getLevel();

    protected abstract Object add(Object var1, int var2, int var3, int var4, int var5, int var6);

    protected void clearFields(Calendar cal) {
    }

    protected abstract Date dateValue(Object var1);

    protected abstract String defaultFormat();

    protected abstract Hashtable formats();

    protected boolean ignoreTimeZone() {
        return false;
    }

    protected abstract Object now();

    protected abstract Object setDate(Date var1);

    public void setMask(String mask) {
        this.format = new SimpleDateFormat(mask);
        this.format.setLenient(false);
        this.format.setTimeZone(UTC_TIME_ZONE);
    }

    protected boolean isEmpty() {
        return false;
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("Etc/UTC");
        if (timeZone == null) {
            timeZone = TimeZone.getTimeZone("UTC");
        }
        UTC_TIME_ZONE = timeZone;
    }
}

