/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.ensure;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.metamodel.commons.ensure.Ensure;

public class EnsureTestsGivenValueThatDoesNotMatch {
    @Test
    public void whenCallEnsureThatArgShouldThrowIllegalArgumentException() {
        try {
            Ensure.ensureThatArg((Object)"foo", (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"illegal argument, expected: is null"));
        }
    }

    @Test
    public void whenCallEnsureThatArgOverloadedShouldThrowIllegalArgumentExceptionUsingSuppliedMessage() {
        try {
            Ensure.ensureThatArg((Object)"foo", (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (String)"my message");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"my message"));
        }
    }

    @Test
    public void whenCallEnsureThatStateShouldThrowIllegalStateException() {
        try {
            Ensure.ensureThatState((Object)"foo", (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"illegal argument, expected: is null"));
        }
    }

    @Test
    public void whenCallEnsureThatStateOverloadedShouldThrowIllegalStateExceptionUsingSuppliedMessage() {
        try {
            Ensure.ensureThatState((Object)"foo", (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (String)"my message");
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"my message"));
        }
    }

    @Test
    public void whenCallEnsureThatContextShouldThrowIllegalThreadStateException() {
        try {
            Ensure.ensureThatContext((Object)"foo", (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            Assert.fail();
        }
        catch (IllegalThreadStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"illegal argument, expected: is null"));
        }
    }

    @Test
    public void whenCallEnsureThatContextOverloadedShouldThrowIllegalThreadStateExceptionUsingSuppliedMessage() {
        try {
            Ensure.ensureThatContext((Object)"foo", (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (String)"my message");
            Assert.fail();
        }
        catch (IllegalThreadStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"my message"));
        }
    }
}

