/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.config.loader;

import junit.framework.TestCase;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.ConfigurationBuilderFileSystem;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.NotFoundPolicy;

public class ConfigurationLoaderFileSystemTest
extends TestCase {
    ConfigurationBuilderFileSystem loader;

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.loader = new ConfigurationBuilderFileSystem(new String[]{"src/test/config"});
    }

    public void testDefaultConfiguration() {
        NakedObjectConfiguration configuration = this.loader.getConfiguration();
        ConfigurationLoaderFileSystemTest.assertEquals((String)"one", (String)configuration.getString("properties.example"));
    }

    public void testDefaultConfigurationTrailingWhitespace() {
        NakedObjectConfiguration configuration = this.loader.getConfiguration();
        ConfigurationLoaderFileSystemTest.assertEquals((String)"in-memory", (String)configuration.getString("properties.trailingWhitespace"));
    }

    public void testAddConfiguration() {
        this.loader.addConfigurationResource("another.properties", NotFoundPolicy.FAIL_FAST);
        NakedObjectConfiguration configuration = this.loader.getConfiguration();
        ConfigurationLoaderFileSystemTest.assertEquals((String)"added", (String)configuration.getString("additional.example"));
    }

    public void testAddedConfigurationOveridesEarlierProperties() {
        this.loader.addConfigurationResource("another.properties", NotFoundPolicy.FAIL_FAST);
        NakedObjectConfiguration configuration = this.loader.getConfiguration();
        ConfigurationLoaderFileSystemTest.assertEquals((String)"two", (String)configuration.getString("properties.example"));
    }

    public void testAddedConfigurationFailsWhenFileNotFound() {
        try {
            this.loader.addConfigurationResource("unfound.properties", NotFoundPolicy.FAIL_FAST);
            this.loader.getConfiguration();
            ConfigurationLoaderFileSystemTest.fail();
        }
        catch (NakedObjectException nakedObjectException) {
            // empty catch block
        }
    }

    public void testAddedConfigurationIgnoreUnfoundFile() {
        this.loader.addConfigurationResource("unfound.properties", NotFoundPolicy.CONTINUE);
        this.loader.getConfiguration();
    }

    public void testAddProperty() throws Exception {
        this.loader.add("added.property", "added by code");
        NakedObjectConfiguration configuration = this.loader.getConfiguration();
        ConfigurationLoaderFileSystemTest.assertEquals((String)"added by code", (String)configuration.getString("added.property"));
    }

    public void testIncludeSystemProperty() throws Exception {
        this.loader.setIncludeSystemProperties(true);
        NakedObjectConfiguration configuration = this.loader.getConfiguration();
        ConfigurationLoaderFileSystemTest.assertEquals((String)System.getProperty("os.name"), (String)configuration.getString("os.name"));
    }
}

