/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.config.prop;

import java.util.Properties;
import junit.framework.TestCase;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.nakedobjects.metamodel.config.internal.PropertiesConfiguration;

public class PropertiesConfigurationWhitespaceTest
extends TestCase {
    private PropertiesConfiguration configuration;

    public PropertiesConfigurationWhitespaceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        BasicConfigurator.configure();
        LogManager.getRootLogger().setLevel(Level.OFF);
        this.configuration = new PropertiesConfiguration();
        Properties p = new Properties();
        p.put("properties.leadingSpaces", "  twoSpacesBeforeThis");
        p.put("properties.leadingTab", "\toneTabBeforeThis");
        p.put("properties.trailingSpaces", "twoSpacesAfterThis  ");
        p.put("properties.trailingTab", "oneTabAfterThis\t");
        p.put("properties.trailingTabAndSpaces", "oneTabAndTwoSpacesAfterThis\t  ");
        this.configuration.add(p);
    }

    public void testLeadingSpaces() {
        PropertiesConfigurationWhitespaceTest.assertEquals((String)"twoSpacesBeforeThis", (String)this.configuration.getString("properties.leadingSpaces"));
    }

    public void testLeadingTab() {
        PropertiesConfigurationWhitespaceTest.assertEquals((String)"oneTabBeforeThis", (String)this.configuration.getString("properties.leadingTab"));
    }

    public void testTrailingSpaces() {
        PropertiesConfigurationWhitespaceTest.assertEquals((String)"twoSpacesAfterThis", (String)this.configuration.getString("properties.trailingSpaces"));
    }

    public void testTrailingTab() {
        PropertiesConfigurationWhitespaceTest.assertEquals((String)"oneTabAfterThis", (String)this.configuration.getString("properties.trailingTab"));
    }

    public void testTrailingTabSpaces() {
        PropertiesConfigurationWhitespaceTest.assertEquals((String)"oneTabAndTwoSpacesAfterThis", (String)this.configuration.getString("properties.trailingTabAndSpaces"));
    }
}

