/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.actions.executed;

import java.lang.reflect.Method;
import org.nakedobjects.applib.annotation.Executed;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.actions.executed.ExecutedAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.actions.executed.ExecutedFacet;
import org.nakedobjects.metamodel.facets.actions.executed.ExecutedFacetAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class ExecutedAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private ExecutedAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new ExecutedAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        ExecutedAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        ExecutedAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        ExecutedAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        ExecutedAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        ExecutedAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testExecutedLocallyAnnotationPickedUp() {
        class Customer {
            Customer() {
            }

            @Executed(value=Executed.Where.LOCALLY)
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ExecutedFacet.class);
        ExecutedAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        ExecutedAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof ExecutedFacetAbstract));
        ExecutedFacetAbstract executedFacetAbstract = (ExecutedFacetAbstract)facet;
        ExecutedAnnotationFacetFactoryTest.assertEquals((Object)NakedObjectActionConstants.LOCAL, (Object)executedFacetAbstract.getTarget());
        this.assertNoMethodsRemoved();
    }

    public void testExecutedRemotelyAnnotationPickedUp() {
        class Customer {
            Customer() {
            }

            @Executed(value=Executed.Where.REMOTELY)
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ExecutedFacet.class);
        ExecutedAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        ExecutedAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof ExecutedFacetAbstract));
        ExecutedFacetAbstract executedFacetAbstract = (ExecutedFacetAbstract)facet;
        ExecutedAnnotationFacetFactoryTest.assertEquals((Object)NakedObjectActionConstants.REMOTE, (Object)executedFacetAbstract.getTarget());
        this.assertNoMethodsRemoved();
    }
}

