/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.naming.named;

import java.lang.reflect.Method;
import java.util.Collection;
import org.nakedobjects.applib.annotation.Named;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.naming.named.NamedAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacet;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacetAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class NamedAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private NamedAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new NamedAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        NamedAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        NamedAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        NamedAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        NamedAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        NamedAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testNamedAnnotationPickedUpOnClass() {
        @Named(value="some name")
        class Customer {
            Customer() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NamedFacet.class);
        NamedAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        NamedAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacetAbstract));
        NamedFacetAbstract namedFacetAbstract = (NamedFacetAbstract)facet;
        NamedAnnotationFacetFactoryTest.assertEquals((String)"some name", (String)namedFacetAbstract.value());
        this.assertNoMethodsRemoved();
    }

    public void testNamedAnnotationPickedUpOnProperty() {
        class Customer {
            Customer() {
            }

            @Named(value="some name")
            public int getNumberOfOrders() {
                return 0;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "getNumberOfOrders");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NamedFacet.class);
        NamedAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        NamedAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacetAbstract));
        NamedFacetAbstract namedFacetAbstract = (NamedFacetAbstract)facet;
        NamedAnnotationFacetFactoryTest.assertEquals((String)"some name", (String)namedFacetAbstract.value());
        this.assertNoMethodsRemoved();
    }

    public void testNamedAnnotationPickedUpOnCollection() {
        class Customer {
            Customer() {
            }

            @Named(value="some name")
            public Collection getOrders() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NamedFacet.class);
        NamedAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        NamedAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacetAbstract));
        NamedFacetAbstract namedFacetAbstract = (NamedFacetAbstract)facet;
        NamedAnnotationFacetFactoryTest.assertEquals((String)"some name", (String)namedFacetAbstract.value());
        this.assertNoMethodsRemoved();
    }

    public void testNamedAnnotationPickedUpOnAction() {
        class Customer {
            Customer() {
            }

            @Named(value="some name")
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NamedFacet.class);
        NamedAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        NamedAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacetAbstract));
        NamedFacetAbstract namedFacetAbstract = (NamedFacetAbstract)facet;
        NamedAnnotationFacetFactoryTest.assertEquals((String)"some name", (String)namedFacetAbstract.value());
        this.assertNoMethodsRemoved();
    }

    public void testNamedAnnotationPickedUpOnActionParameter() {
        class Customer {
            Customer() {
            }

            public void someAction(@Named(value="some name") int x) {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE});
        this.facetFactory.processParams(actionMethod, 0, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NamedFacet.class);
        NamedAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        NamedAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacetAbstract));
        NamedFacetAbstract namedFacetAbstract = (NamedFacetAbstract)facet;
        NamedAnnotationFacetFactoryTest.assertEquals((String)"some name", (String)namedFacetAbstract.value());
    }
}

