/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.callback;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.callbacks.LoadCallbackFacetFactory;
import org.nakedobjects.metamodel.facets.object.callbacks.LoadedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.LoadedCallbackFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.callbacks.LoadingCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.LoadingCallbackFacetViaMethod;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class LoadCallbackFacetFactoryTest
extends AbstractFacetFactoryTest {
    private LoadCallbackFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new LoadCallbackFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        LoadCallbackFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        LoadCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        LoadCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        LoadCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        LoadCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testLoadingLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void loading() {
            }
        }
        Method method = this.findMethod(Customer.class, "loading");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(LoadingCallbackFacet.class);
        LoadCallbackFacetFactoryTest.assertNotNull((Object)facet);
        LoadCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof LoadingCallbackFacetViaMethod));
        LoadingCallbackFacetViaMethod loadingCallbackFacetViaMethod = (LoadingCallbackFacetViaMethod)facet;
        LoadCallbackFacetFactoryTest.assertEquals((Object)method, loadingCallbackFacetViaMethod.getMethods().get(0));
        LoadCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }

    public void testLoadedLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void loaded() {
            }
        }
        Method method = this.findMethod(Customer.class, "loaded");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(LoadedCallbackFacet.class);
        LoadCallbackFacetFactoryTest.assertNotNull((Object)facet);
        LoadCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof LoadedCallbackFacetViaMethod));
        LoadedCallbackFacetViaMethod loadedCallbackFacetViaMethod = (LoadedCallbackFacetViaMethod)facet;
        LoadCallbackFacetFactoryTest.assertEquals((Object)method, loadedCallbackFacetViaMethod.getMethods().get(0));
        LoadCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }
}

