/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.callback;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.callbacks.RemoveCallbackFacetFactory;
import org.nakedobjects.metamodel.facets.object.callbacks.RemovedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.RemovedCallbackFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.callbacks.RemovingCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.RemovingCallbackFacetViaMethod;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class RemoveCallbackFacetFactoryTest
extends AbstractFacetFactoryTest {
    private RemoveCallbackFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new RemoveCallbackFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        RemoveCallbackFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        RemoveCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        RemoveCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        RemoveCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        RemoveCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testRemovingLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void removing() {
            }
        }
        Method method = this.findMethod(Customer.class, "removing");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(RemovingCallbackFacet.class);
        RemoveCallbackFacetFactoryTest.assertNotNull((Object)facet);
        RemoveCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof RemovingCallbackFacetViaMethod));
        RemovingCallbackFacetViaMethod removingCallbackFacetViaMethod = (RemovingCallbackFacetViaMethod)facet;
        RemoveCallbackFacetFactoryTest.assertEquals((Object)method, removingCallbackFacetViaMethod.getMethods().get(0));
        RemoveCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }

    public void testRemovedLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void removed() {
            }
        }
        Method method = this.findMethod(Customer.class, "removed");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(RemovedCallbackFacet.class);
        RemoveCallbackFacetFactoryTest.assertNotNull((Object)facet);
        RemoveCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof RemovedCallbackFacetViaMethod));
        RemovedCallbackFacetViaMethod removedCallbackFacetViaMethod = (RemovedCallbackFacetViaMethod)facet;
        RemoveCallbackFacetFactoryTest.assertEquals((Object)method, removedCallbackFacetViaMethod.getMethods().get(0));
        RemoveCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }
}

