/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.dirty;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.dirty.ClearDirtyObjectFacet;
import org.nakedobjects.metamodel.facets.object.dirty.ClearDirtyObjectFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.dirty.DirtyMethodsFacetFactory;
import org.nakedobjects.metamodel.facets.object.dirty.IsDirtyObjectFacet;
import org.nakedobjects.metamodel.facets.object.dirty.IsDirtyObjectFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.dirty.MarkDirtyObjectFacet;
import org.nakedobjects.metamodel.facets.object.dirty.MarkDirtyObjectFacetViaMethod;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class DirtyMethodsFacetFactoryTest
extends AbstractFacetFactoryTest {
    private DirtyMethodsFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new DirtyMethodsFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        DirtyMethodsFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        DirtyMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        DirtyMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        DirtyMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        DirtyMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testMarkDirtyMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void markDirty() {
            }
        }
        Method method = this.findMethod(Customer.class, "markDirty");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MarkDirtyObjectFacet.class);
        DirtyMethodsFacetFactoryTest.assertNotNull((Object)facet);
        DirtyMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof MarkDirtyObjectFacetViaMethod));
        MarkDirtyObjectFacetViaMethod markDirtyFacet = (MarkDirtyObjectFacetViaMethod)facet;
        DirtyMethodsFacetFactoryTest.assertEquals((Object)method, markDirtyFacet.getMethods().get(0));
        DirtyMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }

    public void testIsDirtyMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public boolean isDirty() {
                return false;
            }
        }
        Method method = this.findMethod(Customer.class, "isDirty");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(IsDirtyObjectFacet.class);
        DirtyMethodsFacetFactoryTest.assertNotNull((Object)facet);
        DirtyMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof IsDirtyObjectFacetViaMethod));
        IsDirtyObjectFacetViaMethod isDirtyFacet = (IsDirtyObjectFacetViaMethod)facet;
        DirtyMethodsFacetFactoryTest.assertEquals((Object)method, isDirtyFacet.getMethods().get(0));
        DirtyMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }

    public void testClearDirtyMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void clearDirty() {
            }
        }
        Method method = this.findMethod(Customer.class, "clearDirty");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ClearDirtyObjectFacet.class);
        DirtyMethodsFacetFactoryTest.assertNotNull((Object)facet);
        DirtyMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof ClearDirtyObjectFacetViaMethod));
        ClearDirtyObjectFacetViaMethod clearDirtyFacet = (ClearDirtyObjectFacetViaMethod)facet;
        DirtyMethodsFacetFactoryTest.assertEquals((Object)method, clearDirtyFacet.getMethods().get(0));
        DirtyMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }
}

