/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.ident.plural;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.ident.plural.PluralFacet;
import org.nakedobjects.metamodel.facets.object.ident.plural.PluralFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.ident.plural.PluralMethodFacetFactory;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class PluralMethodFacetFactoryTest
extends AbstractFacetFactoryTest {
    private PluralMethodFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new PluralMethodFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        PluralMethodFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        PluralMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        PluralMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        PluralMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        PluralMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testPluralNameMethodPickedUpOnClassAndMethodRemoved() {
        Method pluralNameMethod = this.findMethod(Customer.class, "pluralName");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PluralFacet.class);
        PluralMethodFacetFactoryTest.assertNotNull((Object)facet);
        PluralMethodFacetFactoryTest.assertTrue((boolean)(facet instanceof PluralFacetViaMethod));
        PluralFacetViaMethod pluralFacet = (PluralFacetViaMethod)facet;
        PluralMethodFacetFactoryTest.assertEquals((String)"Some plural name", (String)pluralFacet.value());
        PluralMethodFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(pluralNameMethod));
    }

    public static class Customer {
        public static String pluralName() {
            return "Some plural name";
        }
    }
}

