/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.immutable;

import org.nakedobjects.applib.marker.AlwaysImmutable;
import org.nakedobjects.applib.marker.ImmutableOncePersisted;
import org.nakedobjects.applib.marker.ImmutableUntilPersisted;
import org.nakedobjects.applib.marker.NeverImmutable;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.When;
import org.nakedobjects.metamodel.facets.object.immutable.ImmutableFacet;
import org.nakedobjects.metamodel.facets.object.immutable.ImmutableFacetMarkerInterface;
import org.nakedobjects.metamodel.facets.object.immutable.ImmutableMarkerInterfacesFacetFactory;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class ImmutableMarkerInterfaceFacetFactoryTest
extends AbstractFacetFactoryTest {
    private ImmutableMarkerInterfacesFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new ImmutableMarkerInterfacesFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        ImmutableMarkerInterfaceFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        ImmutableMarkerInterfaceFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        ImmutableMarkerInterfaceFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        ImmutableMarkerInterfaceFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        ImmutableMarkerInterfaceFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testAlwaysImmutable() {
        class Customer
        implements AlwaysImmutable {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ImmutableFacet.class);
        ImmutableMarkerInterfaceFacetFactoryTest.assertNotNull((Object)facet);
        ImmutableMarkerInterfaceFacetFactoryTest.assertTrue((boolean)(facet instanceof ImmutableFacetMarkerInterface));
        ImmutableFacetMarkerInterface immutableFacetMarkerInterface = (ImmutableFacetMarkerInterface)facet;
        ImmutableMarkerInterfaceFacetFactoryTest.assertEquals((Object)When.ALWAYS, (Object)immutableFacetMarkerInterface.value());
        this.assertNoMethodsRemoved();
    }

    public void testImmutableOncePersisted() {
        class Customer
        implements ImmutableOncePersisted {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ImmutableFacet.class);
        ImmutableMarkerInterfaceFacetFactoryTest.assertNotNull((Object)facet);
        ImmutableMarkerInterfaceFacetFactoryTest.assertTrue((boolean)(facet instanceof ImmutableFacetMarkerInterface));
        ImmutableFacetMarkerInterface immutableFacetMarkerInterface = (ImmutableFacetMarkerInterface)facet;
        ImmutableMarkerInterfaceFacetFactoryTest.assertEquals((Object)When.ONCE_PERSISTED, (Object)immutableFacetMarkerInterface.value());
        this.assertNoMethodsRemoved();
    }

    public void testImmutableUntilPersisted() {
        class Customer
        implements ImmutableUntilPersisted {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ImmutableFacet.class);
        ImmutableMarkerInterfaceFacetFactoryTest.assertNotNull((Object)facet);
        ImmutableMarkerInterfaceFacetFactoryTest.assertTrue((boolean)(facet instanceof ImmutableFacetMarkerInterface));
        ImmutableFacetMarkerInterface immutableFacetMarkerInterface = (ImmutableFacetMarkerInterface)facet;
        ImmutableMarkerInterfaceFacetFactoryTest.assertEquals((Object)When.UNTIL_PERSISTED, (Object)immutableFacetMarkerInterface.value());
        this.assertNoMethodsRemoved();
    }

    public void testNeverImmutable() {
        class Customer
        implements NeverImmutable {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ImmutableFacet.class);
        ImmutableMarkerInterfaceFacetFactoryTest.assertNotNull((Object)facet);
        ImmutableMarkerInterfaceFacetFactoryTest.assertTrue((boolean)(facet instanceof ImmutableFacetMarkerInterface));
        ImmutableFacetMarkerInterface immutableFacetMarkerInterface = (ImmutableFacetMarkerInterface)facet;
        ImmutableMarkerInterfaceFacetFactoryTest.assertEquals((Object)When.NEVER, (Object)immutableFacetMarkerInterface.value());
        this.assertNoMethodsRemoved();
    }
}

