/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.value;

import org.nakedobjects.applib.adapters.AbstractValueSemanticsProvider;
import org.nakedobjects.applib.adapters.DefaultsProvider;
import org.nakedobjects.applib.adapters.EncoderDecoder;
import org.nakedobjects.applib.adapters.Parser;
import org.nakedobjects.applib.annotation.Value;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.internal.PropertiesConfiguration;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.defaults.DefaultedFacet;
import org.nakedobjects.metamodel.facets.object.ebc.EqualByContentFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.facets.object.ident.title.TitleFacet;
import org.nakedobjects.metamodel.facets.object.immutable.ImmutableFacet;
import org.nakedobjects.metamodel.facets.object.parseable.ParseableFacet;
import org.nakedobjects.metamodel.facets.object.value.ValueFacet;
import org.nakedobjects.metamodel.facets.object.value.ValueFacetAbstract;
import org.nakedobjects.metamodel.facets.object.value.ValueFacetAnnotation;
import org.nakedobjects.metamodel.facets.object.value.ValueFacetFactory;
import org.nakedobjects.metamodel.facets.propparam.typicallength.TypicalLengthFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.noruntime.RuntimeContextNoRuntime;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class ValueFacetFactoryTest
extends AbstractFacetFactoryTest {
    private ValueFacetFactory facetFactory;
    private PropertiesConfiguration propertiesConfiguration;
    private RuntimeContext runtimeContext;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new ValueFacetFactory();
        this.propertiesConfiguration = new PropertiesConfiguration();
        this.runtimeContext = new RuntimeContextNoRuntime();
        this.facetFactory.setNakedObjectConfiguration((NakedObjectConfiguration)this.propertiesConfiguration);
        this.facetFactory.setRuntimeContext(this.runtimeContext);
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        ValueFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        ValueFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        ValueFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        ValueFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        ValueFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testFacetPickedUp() {
        this.facetFactory.process(MyParseableUsingParserName2.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacet facet = (ValueFacet)this.facetHolder.getFacet(ValueFacet.class);
        ValueFacetFactoryTest.assertNotNull((Object)facet);
        ValueFacetFactoryTest.assertTrue((boolean)(facet instanceof ValueFacetAnnotation));
    }

    public void testFacetFacetHolderStored() {
        this.facetFactory.process(MyParseableUsingParserName2.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetAnnotation valueFacet = (ValueFacetAnnotation)this.facetHolder.getFacet(ValueFacet.class);
        ValueFacetFactoryTest.assertEquals((Object)this.facetHolder, (Object)valueFacet.getFacetHolder());
    }

    public void testNoMethodsRemoved() {
        this.facetFactory.process(MyParseableUsingParserName2.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        this.assertNoMethodsRemoved();
    }

    public void testPickUpSemanticsProviderViaNameAndInstallsValueFacet() {
        this.facetFactory.process(MyValueSemanticsProviderUsingSemanticsProviderName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetFactoryTest.assertNotNull((Object)this.facetHolder.getFacet(ValueFacet.class));
    }

    public void testPickUpSemanticsProviderViaClassAndInstallsValueFacet() {
        this.facetFactory.process(MyValueSemanticsProviderUsingSemanticsProviderClass.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetFactoryTest.assertNotNull((Object)this.facetHolder.getFacet(ValueFacet.class));
    }

    public void testValueSemanticsProviderMustBeAValueSemanticsProvider() {
    }

    public void testValueSemanticsProviderMustHaveANoArgConstructor() {
        this.facetFactory.process(MyValueSemanticsProviderWithoutNoArgConstructor.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetFactoryTest.assertNotNull((Object)this.facetHolder.getFacet(ImmutableFacet.class));
    }

    public void testValueSemanticsProviderMustHaveAPublicNoArgConstructor() {
        this.facetFactory.process(MyValueSemanticsProviderWithoutPublicNoArgConstructor.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetFactoryTest.assertNotNull((Object)this.facetHolder.getFacet(ImmutableFacet.class));
    }

    public void testValueSemanticsProviderThatIsNotAParserDoesNotInstallParseableFacet() {
        this.facetFactory.process(MyValueSemanticsProviderUsingSemanticsProviderClass.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(ParseableFacet.class));
    }

    public void testValueSemanticsProviderThatIsAParserInstallsParseableFacet() {
        this.facetFactory.process(MyValueSemanticsProviderThatIsAParser.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetFactoryTest.assertNotNull((Object)this.facetHolder.getFacet(ParseableFacet.class));
    }

    public void testValueSemanticsProviderThatIsAParserInstallsTitleFacet() {
        this.facetFactory.process(MyValueSemanticsProviderThatIsAParser.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetFactoryTest.assertNotNull((Object)this.facetHolder.getFacet(TitleFacet.class));
    }

    public void testValueSemanticsProviderThatIsAParserInstallsTypicalLengthFacet() {
        this.facetFactory.process(MyValueSemanticsProviderThatIsAParser.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetFactoryTest.assertNotNull((Object)this.facetHolder.getFacet(TypicalLengthFacet.class));
    }

    public void testValueSemanticsProviderThatIsNotADefaultsProviderDoesNotInstallDefaultedFacet() {
        this.facetFactory.process(MyValueSemanticsProviderUsingSemanticsProviderClass.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(DefaultedFacet.class));
    }

    public void testValueSemanticsProviderThatIsADefaultsProviderInstallsDefaultedFacet() {
        this.facetFactory.process(MyValueSemanticsProviderThatIsADefaultsProvider.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetFactoryTest.assertNotNull((Object)this.facetHolder.getFacet(DefaultedFacet.class));
    }

    public void testValueSemanticsProviderThatIsNotAnEncoderDecoderDoesNotInstallEncodeableFacet() {
        this.facetFactory.process(MyValueSemanticsProviderUsingSemanticsProviderClass.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(EncodeableFacet.class));
    }

    public void testValueSemanticsProviderThatIsAnEncoderInstallsEncodeableFacet() {
        this.facetFactory.process(MyValueSemanticsProviderThatIsAnEncoderDecoder.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetFactoryTest.assertNotNull((Object)this.facetHolder.getFacet(EncodeableFacet.class));
    }

    public void testImmutableFacetsIsInstalledIfNoSemanticsProviderSpecified() {
        @Value
        class MyNumberImmutableDefault {
            MyNumberImmutableDefault() {
            }
        }
        this.facetFactory.process(MyNumberImmutableDefault.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ImmutableFacet facet = (ImmutableFacet)this.facetHolder.getFacet(ImmutableFacet.class);
        ValueFacetFactoryTest.assertNotNull((Object)facet);
    }

    public void testImmutableFacetsIsInstalledIfSpecifiesImmutable() {
        this.facetFactory.process(MyValueSemanticsProviderThatSpecifiesImmutableSemantic.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ImmutableFacet facet = (ImmutableFacet)this.facetHolder.getFacet(ImmutableFacet.class);
        ValueFacetFactoryTest.assertNotNull((Object)facet);
    }

    public void testImmutableFacetsIsNotInstalledIfSpecifiesNotImmutable() {
        this.facetFactory.process(MyValueSemanticsProviderThatSpecifiesNotImmutableSemantic.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ImmutableFacet facet = (ImmutableFacet)this.facetHolder.getFacet(ImmutableFacet.class);
        ValueFacetFactoryTest.assertNull((Object)facet);
    }

    public void testEqualByContentFacetsIsInstalledIfNoSemanticsProviderSpecified() {
        @Value
        class MyNumberEqualByContentDefault {
            MyNumberEqualByContentDefault() {
            }
        }
        this.facetFactory.process(MyNumberEqualByContentDefault.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EqualByContentFacet facet = (EqualByContentFacet)this.facetHolder.getFacet(EqualByContentFacet.class);
        ValueFacetFactoryTest.assertNotNull((Object)facet);
    }

    public void testEqualByContentFacetsIsInstalledIfSpecifiesEqualByContent() {
        this.facetFactory.process(MyValueSemanticsProviderThatSpecifiesEqualByContentSemantic.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EqualByContentFacet facet = (EqualByContentFacet)this.facetHolder.getFacet(EqualByContentFacet.class);
        ValueFacetFactoryTest.assertNotNull((Object)facet);
    }

    public void testEqualByContentFacetsIsNotInstalledIfSpecifiesNotEqualByContent() {
        this.facetFactory.process(MyValueSemanticsProviderThatSpecifiesNotEqualByContentSemantic.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EqualByContentFacet facet = (EqualByContentFacet)this.facetHolder.getFacet(EqualByContentFacet.class);
        ValueFacetFactoryTest.assertNull((Object)facet);
    }

    public void testSemanticsProviderNameCanBePickedUpFromConfiguration() {
        String className = "org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$MyValueWithSemanticsProviderSpecifiedUsingConfiguration";
        this.propertiesConfiguration.add("nakedobjects.reflector.java.facets.value." + this.canonical("org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$MyValueWithSemanticsProviderSpecifiedUsingConfiguration") + ".semanticsProviderName", "org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$MyValueWithSemanticsProviderSpecifiedUsingConfiguration");
        this.facetFactory.process(MyValueWithSemanticsProviderSpecifiedUsingConfiguration.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetAbstract facet = (ValueFacetAbstract)this.facetHolder.getFacet(ValueFacet.class);
        ValueFacetFactoryTest.assertNotNull((Object)facet);
        ParseableFacet parseableFacet = (ParseableFacet)this.facetHolder.getFacet(ParseableFacet.class);
        ValueFacetFactoryTest.assertNotNull((Object)parseableFacet);
    }

    public void testNonAnnotatedValueCanPickUpSemanticsProviderFromConfiguration() {
        String className = "org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$NonAnnotatedValueSemanticsProviderSpecifiedUsingConfiguration";
        this.propertiesConfiguration.add("nakedobjects.reflector.java.facets.value." + this.canonical("org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$NonAnnotatedValueSemanticsProviderSpecifiedUsingConfiguration") + ".semanticsProviderName", "org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$NonAnnotatedValueSemanticsProviderSpecifiedUsingConfiguration");
        this.facetFactory.process(NonAnnotatedValueSemanticsProviderSpecifiedUsingConfiguration.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ValueFacetAbstract facet = (ValueFacetAbstract)this.facetHolder.getFacet(ValueFacet.class);
        ValueFacetFactoryTest.assertNotNull((Object)facet);
        ParseableFacet parseableFacet = (ParseableFacet)this.facetHolder.getFacet(ParseableFacet.class);
        ValueFacetFactoryTest.assertNotNull((Object)parseableFacet);
    }

    private String canonical(String className) {
        return className.replace('$', '.');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NonAnnotatedValueSemanticsProviderSpecifiedUsingConfiguration
    extends AbstractValueSemanticsProvider<NonAnnotatedValueSemanticsProviderSpecifiedUsingConfiguration>
    implements Parser<NonAnnotatedValueSemanticsProviderSpecifiedUsingConfiguration> {
        public NonAnnotatedValueSemanticsProviderSpecifiedUsingConfiguration parseTextEntry(NonAnnotatedValueSemanticsProviderSpecifiedUsingConfiguration context, String entry) {
            return null;
        }

        public String displayTitleOf(NonAnnotatedValueSemanticsProviderSpecifiedUsingConfiguration object) {
            return null;
        }

        public String parseableTitleOf(NonAnnotatedValueSemanticsProviderSpecifiedUsingConfiguration existing) {
            return null;
        }

        public int typicalLength() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value
    public static class MyValueWithSemanticsProviderSpecifiedUsingConfiguration
    extends AbstractValueSemanticsProvider<MyValueWithSemanticsProviderSpecifiedUsingConfiguration>
    implements Parser<MyValueWithSemanticsProviderSpecifiedUsingConfiguration> {
        public MyValueWithSemanticsProviderSpecifiedUsingConfiguration parseTextEntry(MyValueWithSemanticsProviderSpecifiedUsingConfiguration context, String entry) {
            return null;
        }

        public String displayTitleOf(MyValueWithSemanticsProviderSpecifiedUsingConfiguration object) {
            return null;
        }

        public String parseableTitleOf(MyValueWithSemanticsProviderSpecifiedUsingConfiguration existing) {
            return null;
        }

        public int typicalLength() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value(semanticsProviderName="org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$MyValueSemanticsProviderThatSpecifiesNotEqualByContentSemantic")
    public static class MyValueSemanticsProviderThatSpecifiesNotEqualByContentSemantic
    extends AbstractValueSemanticsProvider<MyValueSemanticsProviderThatSpecifiesNotEqualByContentSemantic> {
        public MyValueSemanticsProviderThatSpecifiesNotEqualByContentSemantic() {
            super(false, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value(semanticsProviderName="org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$MyValueSemanticsProviderThatSpecifiesEqualByContentSemantic")
    public static class MyValueSemanticsProviderThatSpecifiesEqualByContentSemantic
    extends AbstractValueSemanticsProvider<MyValueSemanticsProviderThatSpecifiesEqualByContentSemantic> {
        public MyValueSemanticsProviderThatSpecifiesEqualByContentSemantic() {
            super(true, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value(semanticsProviderName="org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$MyValueSemanticsProviderThatSpecifiesNotImmutableSemantic")
    public static class MyValueSemanticsProviderThatSpecifiesNotImmutableSemantic
    extends AbstractValueSemanticsProvider<MyValueSemanticsProviderThatSpecifiesNotImmutableSemantic> {
        public MyValueSemanticsProviderThatSpecifiesNotImmutableSemantic() {
            super(false, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value(semanticsProviderName="org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$MyValueSemanticsProviderThatSpecifiesImmutableSemantic")
    public static class MyValueSemanticsProviderThatSpecifiesImmutableSemantic
    extends AbstractValueSemanticsProvider<MyValueSemanticsProviderThatSpecifiesImmutableSemantic> {
        public MyValueSemanticsProviderThatSpecifiesImmutableSemantic() {
            super(true, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value(semanticsProviderName="org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$MyValueSemanticsProviderThatIsAnEncoderDecoder")
    public static class MyValueSemanticsProviderThatIsAnEncoderDecoder
    extends AbstractValueSemanticsProvider<MyValueSemanticsProviderThatIsAnEncoderDecoder>
    implements EncoderDecoder<MyValueSemanticsProviderThatIsAnEncoderDecoder> {
        public MyValueSemanticsProviderThatIsAnEncoderDecoder fromEncodedString(String encodedString) {
            return null;
        }

        public String toEncodedString(MyValueSemanticsProviderThatIsAnEncoderDecoder toEncode) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value(semanticsProviderName="org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$MyValueSemanticsProviderThatIsADefaultsProvider")
    public static class MyValueSemanticsProviderThatIsADefaultsProvider
    extends AbstractValueSemanticsProvider<MyValueSemanticsProviderThatIsADefaultsProvider>
    implements DefaultsProvider<MyValueSemanticsProviderThatIsADefaultsProvider> {
        public MyValueSemanticsProviderThatIsADefaultsProvider getDefaultValue() {
            return new MyValueSemanticsProviderThatIsADefaultsProvider();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value(semanticsProviderName="org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$MyValueSemanticsProviderThatIsAParser")
    public static class MyValueSemanticsProviderThatIsAParser
    extends AbstractValueSemanticsProvider<MyValueSemanticsProviderThatIsAParser>
    implements Parser<MyValueSemanticsProviderThatIsAParser> {
        public MyValueSemanticsProviderThatIsAParser parseTextEntry(MyValueSemanticsProviderThatIsAParser context, String entry) {
            return null;
        }

        public String displayTitleOf(MyValueSemanticsProviderThatIsAParser object) {
            return null;
        }

        public String parseableTitleOf(MyValueSemanticsProviderThatIsAParser existing) {
            return null;
        }

        public int typicalLength() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value(semanticsProviderClass=MyValueSemanticsProviderWithoutPublicNoArgConstructor.class)
    public static class MyValueSemanticsProviderWithoutPublicNoArgConstructor
    extends AbstractValueSemanticsProvider<MyValueSemanticsProviderWithoutPublicNoArgConstructor> {
        MyValueSemanticsProviderWithoutPublicNoArgConstructor() {
            super(false, false);
        }

        public MyValueSemanticsProviderWithoutPublicNoArgConstructor(int value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value(semanticsProviderClass=MyValueSemanticsProviderWithoutNoArgConstructor.class)
    public static class MyValueSemanticsProviderWithoutNoArgConstructor
    extends AbstractValueSemanticsProvider<MyValueSemanticsProviderWithoutNoArgConstructor> {
        public MyValueSemanticsProviderWithoutNoArgConstructor(int value) {
            super(false, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value(semanticsProviderClass=MyValueSemanticsProviderUsingSemanticsProviderClass.class)
    public static class MyValueSemanticsProviderUsingSemanticsProviderClass
    extends AbstractValueSemanticsProvider<MyValueSemanticsProviderUsingSemanticsProviderClass> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value(semanticsProviderName="org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$MyValueSemanticsProviderUsingSemanticsProviderName")
    public static class MyValueSemanticsProviderUsingSemanticsProviderName
    extends AbstractValueSemanticsProvider<MyValueSemanticsProviderUsingSemanticsProviderName> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Value(semanticsProviderName="org.nakedobjects.metamodel.facets.object.value.ValueFacetFactoryTest$MyParseableUsingParserName2")
    public static class MyParseableUsingParserName2
    extends AbstractValueSemanticsProvider<MyValueSemanticsProviderUsingSemanticsProviderName> {
    }
}

