/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propcoll.notpersisted;

import java.lang.reflect.Method;
import java.util.Collection;
import org.nakedobjects.applib.annotation.NotPersisted;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.propcoll.notpersisted.NotPersistedAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.propcoll.notpersisted.NotPersistedFacet;
import org.nakedobjects.metamodel.facets.propcoll.notpersisted.NotPersistedFacetAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class NotPersistedAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private NotPersistedAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new NotPersistedAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        NotPersistedAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        NotPersistedAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        NotPersistedAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        NotPersistedAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        NotPersistedAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testNotPersistedAnnotationPickedUpOnProperty() {
        class Customer {
            Customer() {
            }

            @NotPersisted
            public String getFirstName() {
                return null;
            }
        }
        Method method = this.findMethod(Customer.class, "getFirstName");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NotPersistedFacet.class);
        NotPersistedAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        NotPersistedAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof NotPersistedFacetAnnotation));
        this.assertNoMethodsRemoved();
    }

    public void testNotPersistedAnnotationPickedUpOnCollection() {
        class Customer {
            Customer() {
            }

            @NotPersisted
            public Collection getOrders() {
                return null;
            }
        }
        Method method = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NotPersistedFacet.class);
        NotPersistedAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        NotPersistedAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof NotPersistedFacetAnnotation));
        this.assertNoMethodsRemoved();
    }
}

