/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.properties;

import java.lang.reflect.Method;
import org.nakedobjects.applib.security.UserMemento;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.actions.DescribedAsFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.NamedFacetViaMethod;
import org.nakedobjects.metamodel.facets.disable.DisableForContextFacet;
import org.nakedobjects.metamodel.facets.disable.DisableForContextFacetViaMethod;
import org.nakedobjects.metamodel.facets.disable.DisableForSessionFacet;
import org.nakedobjects.metamodel.facets.disable.DisableForSessionFacetViaMethod;
import org.nakedobjects.metamodel.facets.disable.DisabledFacet;
import org.nakedobjects.metamodel.facets.disable.DisabledFacetAlways;
import org.nakedobjects.metamodel.facets.hide.HiddenFacet;
import org.nakedobjects.metamodel.facets.hide.HiddenFacetAlways;
import org.nakedobjects.metamodel.facets.hide.HideForContextFacet;
import org.nakedobjects.metamodel.facets.hide.HideForContextFacetViaMethod;
import org.nakedobjects.metamodel.facets.hide.HideForSessionFacet;
import org.nakedobjects.metamodel.facets.hide.HideForSessionFacetViaMethod;
import org.nakedobjects.metamodel.facets.naming.describedas.DescribedAsFacet;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacet;
import org.nakedobjects.metamodel.facets.propcoll.access.PropertyAccessorFacet;
import org.nakedobjects.metamodel.facets.propcoll.access.PropertyAccessorFacetViaAccessor;
import org.nakedobjects.metamodel.facets.propcoll.derived.DerivedFacet;
import org.nakedobjects.metamodel.facets.propcoll.derived.DerivedFacetInferred;
import org.nakedobjects.metamodel.facets.properties.PropertyMethodsFacetFactory;
import org.nakedobjects.metamodel.facets.properties.choices.PropertyChoicesFacet;
import org.nakedobjects.metamodel.facets.properties.choices.PropertyChoicesFacetViaMethod;
import org.nakedobjects.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.nakedobjects.metamodel.facets.properties.defaults.PropertyDefaultFacetViaMethod;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyClearFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyClearFacetViaClearMethod;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyClearFacetViaSetterMethod;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyInitializationFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyInitializationFacetViaSetterMethod;
import org.nakedobjects.metamodel.facets.properties.modify.PropertySetterFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertySetterFacetViaModifyMethod;
import org.nakedobjects.metamodel.facets.properties.modify.PropertySetterFacetViaSetterMethod;
import org.nakedobjects.metamodel.facets.properties.validate.PropertyValidateFacet;
import org.nakedobjects.metamodel.facets.properties.validate.PropertyValidateFacetViaMethod;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;

public class PropertyFieldMethodsFacetFactoryTest
extends AbstractFacetFactoryTest {
    private PropertyMethodsFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new PropertyMethodsFacetFactory();
        this.facetFactory.setSpecificationLoader((SpecificationLoader)this.reflector);
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        PropertyFieldMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        PropertyFieldMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        PropertyFieldMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        PropertyFieldMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testPropertyAccessorFacetIsInstalledAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertyAccessorFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertyAccessorFacetViaAccessor));
        PropertyAccessorFacetViaAccessor propertyAccessorFacetViaAccessor = (PropertyAccessorFacetViaAccessor)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertyAccessorMethod, propertyAccessorFacetViaAccessor.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyAccessorMethod));
    }

    public void testSetterFacetIsInstalledForSetterMethodAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public void setFirstName(String firstName) {
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertySetterMethod = this.findMethod(Customer.class, "setFirstName", new Class[]{String.class});
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertySetterFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertySetterFacetViaSetterMethod));
        PropertySetterFacetViaSetterMethod propertySetterFacet = (PropertySetterFacetViaSetterMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertySetterMethod, propertySetterFacet.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertySetterMethod));
    }

    public void testInitializationFacetIsInstalledForSetterMethodAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public void setFirstName(String firstName) {
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertySetterMethod = this.findMethod(Customer.class, "setFirstName", new Class[]{String.class});
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertyInitializationFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertyInitializationFacet));
        PropertyInitializationFacetViaSetterMethod propertySetterFacet = (PropertyInitializationFacetViaSetterMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertySetterMethod, propertySetterFacet.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertySetterMethod));
    }

    public void testSetterFacetIsInstalledMeansNoDisabledOrDerivedFacetsInstalled() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public void setFirstName(String firstName) {
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        PropertyFieldMethodsFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(DerivedFacet.class));
        PropertyFieldMethodsFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(DisabledFacet.class));
    }

    public void testSetterFacetIsInstalledForModifyMethodAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public void modifyFirstName(String firstName) {
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertyModifyMethod = this.findMethod(Customer.class, "modifyFirstName", new Class[]{String.class});
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertySetterFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertySetterFacetViaModifyMethod));
        PropertySetterFacetViaModifyMethod propertySetterFacet = (PropertySetterFacetViaModifyMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertyModifyMethod, propertySetterFacet.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyModifyMethod));
    }

    public void testModifyMethodWithNoSetterStillInstallsDisabledAndDerivedFacets() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public void modifyFirstName(String firstName) {
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertyModifyMethod = this.findMethod(Customer.class, "modifyFirstName", new Class[]{String.class});
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DerivedFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DerivedFacetInferred));
        facet = this.facetHolder.getFacet(DisabledFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DisabledFacetAlways));
    }

    public void testIfHaveSetterAndModifyFacetThenTheModifyFacetWinsOut() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public void setFirstName(String firstName) {
            }

            public void modifyFirstName(String firstName) {
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertySetterMethod = this.findMethod(Customer.class, "setFirstName", new Class[]{String.class});
        Method propertyModifyMethod = this.findMethod(Customer.class, "modifyFirstName", new Class[]{String.class});
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertySetterFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertySetterFacetViaModifyMethod));
        PropertySetterFacetViaModifyMethod propertySetterFacet = (PropertySetterFacetViaModifyMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertyModifyMethod, propertySetterFacet.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertySetterMethod));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyModifyMethod));
    }

    public void testClearFacet() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public void clearFirstName() {
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertyClearMethod = this.findMethod(Customer.class, "clearFirstName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertyClearFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertyClearFacetViaClearMethod));
        PropertyClearFacetViaClearMethod propertyClearFacet = (PropertyClearFacetViaClearMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertyClearMethod, propertyClearFacet.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyClearMethod));
    }

    public void testClearFacetViaSetterIfNoExplicitClearMethod() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public void setFirstName(String firstName) {
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertySetterMethod = this.findMethod(Customer.class, "setFirstName", new Class[]{String.class});
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertyClearFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertyClearFacetViaSetterMethod));
        PropertyClearFacetViaSetterMethod propertyClearFacet = (PropertyClearFacetViaSetterMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertySetterMethod, propertyClearFacet.getMethods().get(0));
    }

    public void testChoicesFacetFoundAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public Object[] choicesFirstName() {
                return null;
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertyChoicesMethod = this.findMethod(Customer.class, "choicesFirstName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertyChoicesFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertyChoicesFacetViaMethod));
        PropertyChoicesFacetViaMethod propertyChoicesFacet = (PropertyChoicesFacetViaMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertyChoicesMethod, propertyChoicesFacet.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyChoicesMethod));
    }

    public void testDefaultFacetFoundAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public String defaultFirstName() {
                return null;
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertyDefaultMethod = this.findMethod(Customer.class, "defaultFirstName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertyDefaultFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertyDefaultFacetViaMethod));
        PropertyDefaultFacetViaMethod propertyDefaultFacet = (PropertyDefaultFacetViaMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertyDefaultMethod, propertyDefaultFacet.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyDefaultMethod));
    }

    public void testValidateFacetFoundAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public String validateFirstName(String firstName) {
                return null;
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertyValidateMethod = this.findMethod(Customer.class, "validateFirstName", new Class[]{String.class});
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertyValidateFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertyValidateFacetViaMethod));
        PropertyValidateFacetViaMethod propertyValidateFacet = (PropertyValidateFacetViaMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertyValidateMethod, propertyValidateFacet.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyValidateMethod));
    }

    public void testDisableFacetFoundAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public String disableFirstName(String fn) {
                return "disabled";
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertyDisableMethod = this.findMethod(Customer.class, "disableFirstName", new Class[]{String.class});
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisableForContextFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DisableForContextFacetViaMethod));
        DisableForContextFacetViaMethod disableForContextFacet = (DisableForContextFacetViaMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertyDisableMethod, disableForContextFacet.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyDisableMethod));
    }

    public void testDisableFacetNoArgsFoundAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public String disableFirstName() {
                return "disabled";
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertyDisableMethod = this.findMethod(Customer.class, "disableFirstName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisableForContextFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DisableForContextFacetViaMethod));
        DisableForContextFacetViaMethod disableForContextFacet = (DisableForContextFacetViaMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertyDisableMethod, disableForContextFacet.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyDisableMethod));
    }

    public void testHiddenFacetFoundAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public boolean hideFirstName(String fn) {
                return true;
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertyHideMethod = this.findMethod(Customer.class, "hideFirstName", new Class[]{String.class});
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HideForContextFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof HideForContextFacetViaMethod));
        HideForContextFacetViaMethod hideForContextFacet = (HideForContextFacetViaMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertyHideMethod, hideForContextFacet.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyHideMethod));
    }

    public void testHiddenFacetWithNoArgFoundAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String getFirstName() {
                return null;
            }

            public boolean hideFirstName() {
                return true;
            }
        }
        Method propertyAccessorMethod = this.findMethod(Customer.class, "getFirstName");
        Method propertyHideMethod = this.findMethod(Customer.class, "hideFirstName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HideForContextFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof HideForContextFacetViaMethod));
        HideForContextFacetViaMethod hideForContextFacet = (HideForContextFacetViaMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)propertyHideMethod, hideForContextFacet.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyHideMethod));
    }

    public void testInstallsNamedFacetUsingNameMethodAndRemovesMethod() {
        Method propertyAccessorMethod = this.findMethod(CustomerStatic.class, "getFirstName");
        Method nameMethod = this.findMethod(CustomerStatic.class, "nameFirstName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NamedFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacetViaMethod));
        NamedFacetViaMethod namedFacet = (NamedFacetViaMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((String)"Given name", (String)namedFacet.value());
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(nameMethod));
    }

    public void testInstallsDescribedAsFacetUsingDescriptionAndRemovesMethod() {
        Method propertyAccessorMethod = this.findMethod(CustomerStatic.class, "getFirstName");
        Method descriptionMethod = this.findMethod(CustomerStatic.class, "descriptionFirstName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DescribedAsFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DescribedAsFacetViaMethod));
        DescribedAsFacetViaMethod describedAsFacet = (DescribedAsFacetViaMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((String)"Some old description", (String)describedAsFacet.value());
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(descriptionMethod));
    }

    public void testInstallsHiddenFacetUsingAlwaysHideAndRemovesMethod() {
        Method propertyAccessorMethod = this.findMethod(CustomerStatic.class, "getFirstName");
        Method propertyAlwaysHideMethod = this.findMethod(CustomerStatic.class, "alwaysHideFirstName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HiddenFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof HiddenFacetAlways));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyAlwaysHideMethod));
    }

    public void testInstallsHiddenFacetUsingAlwaysHideWhenNotAndRemovesMethod() {
        Method propertyAccessorMethod = this.findMethod(CustomerStatic.class, "getLastName");
        Method propertyAlwaysHideMethod = this.findMethod(CustomerStatic.class, "alwaysHideLastName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        PropertyFieldMethodsFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(HiddenFacet.class));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyAlwaysHideMethod));
    }

    public void testInstallsDisabledFacetUsingProtectAndRemovesMethod() {
        Method propertyAccessorMethod = this.findMethod(CustomerStatic.class, "getFirstName");
        Method propertyProtectMethod = this.findMethod(CustomerStatic.class, "protectFirstName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisabledFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DisabledFacetAlways));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyProtectMethod));
    }

    public void testDoesNotInstallDisabledFacetUsingProtectWhenNotAndRemovesMethod() {
        Method propertyAccessorMethod = this.findMethod(CustomerStatic.class, "getLastName");
        Method propertyProtectMethod = this.findMethod(CustomerStatic.class, "protectLastName");
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisabledFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(propertyProtectMethod));
    }

    public void testInstallsHiddenForSessionFacetAndRemovesMethod() {
        Method propertyAccessorMethod = this.findMethod(CustomerStatic.class, "getFirstName");
        Method hideMethod = this.findMethod(CustomerStatic.class, "hideFirstName", new Class[]{UserMemento.class});
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HideForSessionFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof HideForSessionFacetViaMethod));
        HideForSessionFacetViaMethod hideForSessionFacetViaMethod = (HideForSessionFacetViaMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)hideMethod, hideForSessionFacetViaMethod.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(hideMethod));
    }

    public void testInstallsDisabledForSessionFacetAndRemovesMethod() {
        Method propertyAccessorMethod = this.findMethod(CustomerStatic.class, "getFirstName");
        Method disableMethod = this.findMethod(CustomerStatic.class, "disableFirstName", new Class[]{UserMemento.class});
        this.facetFactory.process(propertyAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisableForSessionFacet.class);
        PropertyFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DisableForSessionFacetViaMethod));
        DisableForSessionFacetViaMethod disableForSessionFacetViaMethod = (DisableForSessionFacetViaMethod)facet;
        PropertyFieldMethodsFacetFactoryTest.assertEquals((Object)disableMethod, disableForSessionFacetViaMethod.getMethods().get(0));
        PropertyFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(disableMethod));
    }

    public static class CustomerStatic {
        public String getFirstName() {
            return null;
        }

        public void setFirstName(String firstName) {
        }

        public static String nameFirstName() {
            return "Given name";
        }

        public static String descriptionFirstName() {
            return "Some old description";
        }

        public static boolean alwaysHideFirstName() {
            return true;
        }

        public static boolean protectFirstName() {
            return true;
        }

        public static boolean hideFirstName(UserMemento userMemento) {
            return true;
        }

        public static String disableFirstName(UserMemento userMemento) {
            return "disabled for this user";
        }

        public String getLastName() {
            return null;
        }

        public void setLastName(String firstName) {
        }

        public static boolean alwaysHideLastName() {
            return false;
        }

        public static boolean protectLastName() {
            return false;
        }
    }
}

