/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.multiline;

import java.lang.reflect.Method;
import org.nakedobjects.applib.annotation.MultiLine;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.propparam.multiline.MultiLineAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.propparam.multiline.MultiLineFacet;
import org.nakedobjects.metamodel.facets.propparam.multiline.MultiLineFacetAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class MultiLineAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private MultiLineAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new MultiLineAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        MultiLineAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        MultiLineAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        MultiLineAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        MultiLineAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        MultiLineAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testMultiLineAnnotationPickedUpOnClass() {
        @MultiLine(numberOfLines=3, preventWrapping=false)
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MultiLineFacet.class);
        MultiLineAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        MultiLineAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof MultiLineFacetAnnotation));
        MultiLineFacetAnnotation multiLineFacetAnnotation = (MultiLineFacetAnnotation)facet;
        MultiLineAnnotationFacetFactoryTest.assertEquals((int)3, (int)multiLineFacetAnnotation.numberOfLines());
        MultiLineAnnotationFacetFactoryTest.assertEquals((boolean)false, (boolean)multiLineFacetAnnotation.preventWrapping());
    }

    public void testMultiLineAnnotationPickedUpOnProperty() {
        class Customer {
            Customer() {
            }

            @MultiLine(numberOfLines=12, preventWrapping=true)
            public String getFirstName() {
                return null;
            }
        }
        Method method = this.findMethod(Customer.class, "getFirstName");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MultiLineFacet.class);
        MultiLineAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        MultiLineAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof MultiLineFacetAnnotation));
        MultiLineFacetAnnotation multiLineFacetAnnotation = (MultiLineFacetAnnotation)facet;
        MultiLineAnnotationFacetFactoryTest.assertEquals((int)12, (int)multiLineFacetAnnotation.numberOfLines());
        MultiLineAnnotationFacetFactoryTest.assertEquals((boolean)true, (boolean)multiLineFacetAnnotation.preventWrapping());
    }

    public void testMultiLineAnnotationPickedUpOnActionParameter() {
        class Customer {
            Customer() {
            }

            public void someAction(@MultiLine(numberOfLines=8, preventWrapping=false) String foo) {
            }
        }
        Method method = this.findMethod(Customer.class, "someAction", new Class[]{String.class});
        this.facetFactory.processParams(method, 0, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MultiLineFacet.class);
        MultiLineAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        MultiLineAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof MultiLineFacetAnnotation));
        MultiLineFacetAnnotation multiLineFacetAnnotation = (MultiLineFacetAnnotation)facet;
        MultiLineAnnotationFacetFactoryTest.assertEquals((int)8, (int)multiLineFacetAnnotation.numberOfLines());
        MultiLineAnnotationFacetFactoryTest.assertEquals((boolean)false, (boolean)multiLineFacetAnnotation.preventWrapping());
    }

    public void testMultiLineAnnotationDefaults() {
        @MultiLine
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MultiLineFacet.class);
        MultiLineFacetAnnotation multiLineFacetAnnotation = (MultiLineFacetAnnotation)facet;
        MultiLineAnnotationFacetFactoryTest.assertEquals((int)6, (int)multiLineFacetAnnotation.numberOfLines());
        MultiLineAnnotationFacetFactoryTest.assertEquals((boolean)true, (boolean)multiLineFacetAnnotation.preventWrapping());
    }

    public void testMultiLineAnnotationIgnoredForNonStringProperties() {
        class Customer {
            Customer() {
            }

            @MultiLine(numberOfLines=8, preventWrapping=false)
            public int getNumberOfOrders() {
                return 0;
            }
        }
        Method method = this.findMethod(Customer.class, "getNumberOfOrders");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MultiLineFacet.class);
        MultiLineAnnotationFacetFactoryTest.assertNull((Object)facet);
    }

    public void testMultiLineAnnotationIgnoredForNonStringActionParameters() {
        class Customer {
            Customer() {
            }

            public void someAction(@MultiLine(numberOfLines=8, preventWrapping=false) int foo) {
            }
        }
        Method method = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE});
        this.facetFactory.processParams(method, 0, (FacetHolder)this.facetHolder);
        MultiLineAnnotationFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(MultiLineFacet.class));
    }
}

