/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.validate.regex;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.propparam.validate.regex.RegExFacetAnnotation;

@RunWith(value=JMock.class)
public class RegExFacetAnnotationTest {
    private final Mockery context = new JUnit4Mockery();
    private RegExFacetAnnotation regExFacetAnnotation;
    private FacetHolder facetHolder;

    @Before
    public void setUp() throws Exception {
        this.facetHolder = (FacetHolder)this.context.mock(FacetHolder.class);
    }

    @After
    public void tearDown() throws Exception {
        this.facetHolder = null;
        this.regExFacetAnnotation = null;
    }

    @Test
    public void shouldBeAbleToInstantiate() {
        this.regExFacetAnnotation = new RegExFacetAnnotation(".*", "", true, this.facetHolder);
    }

    @Test
    public void shouldAllowDotStar() {
        this.regExFacetAnnotation = new RegExFacetAnnotation(".*", "", true, this.facetHolder);
        Assert.assertThat((Object)this.regExFacetAnnotation.doesNotMatch("abc"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldAllowWhenCaseSensitive() {
        this.regExFacetAnnotation = new RegExFacetAnnotation("^abc$", "", true, this.facetHolder);
        Assert.assertThat((Object)this.regExFacetAnnotation.doesNotMatch("abc"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldAllowWhenCaseInsensitive() {
        this.regExFacetAnnotation = new RegExFacetAnnotation("^abc$", "", false, this.facetHolder);
        Assert.assertThat((Object)this.regExFacetAnnotation.doesNotMatch("ABC"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldDisallowWhenCaseSensitive() {
        this.regExFacetAnnotation = new RegExFacetAnnotation("^abc$", "", true, this.facetHolder);
        Assert.assertThat((Object)this.regExFacetAnnotation.doesNotMatch("abC"), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldDisallowWhenCaseInsensitive() {
        this.regExFacetAnnotation = new RegExFacetAnnotation("^abc$", "", false, this.facetHolder);
        Assert.assertThat((Object)this.regExFacetAnnotation.doesNotMatch("aBd"), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldReformat() {
        this.regExFacetAnnotation = new RegExFacetAnnotation("^([0-9]{2})([0-9]{2})([0-9]{2})$", "$1-$2-$3", false, this.facetHolder);
        Assert.assertThat((Object)this.regExFacetAnnotation.doesNotMatch("123456"), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)this.regExFacetAnnotation.format("123456"), (Matcher)CoreMatchers.equalTo((Object)"12-34-56"));
    }
}

