/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.services;

import java.util.Arrays;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.DomainObjectContainer;
import org.nakedobjects.metamodel.services.ServicesInjectorAbstract;

@RunWith(value=JMock.class)
public class ServicesInjectorAbstractTest {
    private Mockery mockery = new JUnit4Mockery();
    private ServicesInjectorAbstract injector;
    private DomainObjectContainerExtended mockContainer;
    private Service1 mockService1;
    private Service2 mockService2;
    private SomeDomainObject mockDomainObject;

    @Before
    public void setUp() throws Exception {
        this.mockDomainObject = (SomeDomainObject)this.mockery.mock(SomeDomainObject.class);
        this.mockContainer = (DomainObjectContainerExtended)this.mockery.mock(DomainObjectContainerExtended.class);
        this.mockService1 = (Service1)this.mockery.mock(Service1.class);
        this.mockService2 = (Service2)this.mockery.mock(Service2.class);
        this.injector = new ServicesInjectorAbstract(){};
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void shouldInjectContainer() {
        this.injector.setContainer((DomainObjectContainer)this.mockContainer);
        Object[] services = new Object[]{this.mockService1, this.mockService2};
        this.injector.setServices(Arrays.asList(services));
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((SomeDomainObject)this.one(ServicesInjectorAbstractTest.this.mockDomainObject)).setContainer(ServicesInjectorAbstractTest.this.mockContainer);
                ((SomeDomainObject)this.one(ServicesInjectorAbstractTest.this.mockDomainObject)).setMixin(ServicesInjectorAbstractTest.this.mockContainer);
                ((SomeDomainObject)this.one(ServicesInjectorAbstractTest.this.mockDomainObject)).setService1(ServicesInjectorAbstractTest.this.mockService1);
                ((SomeDomainObject)this.one(ServicesInjectorAbstractTest.this.mockDomainObject)).setService2(ServicesInjectorAbstractTest.this.mockService2);
            }
        });
        this.injector.injectDependencies((Object)this.mockDomainObject);
    }

    static interface SomeDomainObject {
        public void setContainer(DomainObjectContainer var1);

        public void setMixin(Mixin var1);

        public void setService1(Service1 var1);

        public void setService2(Service2 var1);
    }

    static interface DomainObjectContainerExtended
    extends DomainObjectContainer,
    Mixin {
    }

    static interface Mixin {
    }

    static interface Service2 {
    }

    static interface Service1 {
    }
}

