/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.math.BigInteger;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.BigIntegerValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class BigIntValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private BigInteger bigInt;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.bigInt = new BigInteger("132199");
        this.allowMockAdapterToReturn(this.bigInt);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(BigIntValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.int");
                this.will(1.returnValue(null));
            }
        });
        this.holder = new FacetHolderImpl();
        this.setValue((ValueSemanticsProviderAbstract)new BigIntegerValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext));
    }

    @Test
    public void testParseValidString() throws Exception {
        Object newValue = this.getValue().parseTextEntry(null, "2142342334");
        Assert.assertEquals((Object)new BigInteger("2142342334"), (Object)newValue);
    }

    @Test
    public void testParseInvalidString() throws Exception {
        try {
            this.getValue().parseTextEntry(null, "214xxx2342334");
            Assert.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testTitle() throws Exception {
        Assert.assertEquals((Object)"132,199", (Object)this.getValue().displayTitleOf((Object)this.bigInt));
    }

    @Test
    public void testEncode() throws Exception {
        Assert.assertEquals((Object)"132199", (Object)this.getValue().toEncodedString((Object)this.bigInt));
    }

    @Test
    public void testDecode() throws Exception {
        Object newValue = this.getValue().fromEncodedString("432289991");
        Assert.assertEquals((Object)new BigInteger("432289991"), (Object)newValue);
    }
}

