/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.util.Locale;
import org.jmock.integration.junit4.JMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.value.Money;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.MoneyValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class MoneyValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private static final String POUND_SYMBOL = "\u00a3";
    private static final String EURO_SYMBOL = "\u20ac";
    private MoneyValueSemanticsProvider adapter;
    private Object originalMoney;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        Locale.setDefault(Locale.UK);
        this.setupSpecification(Money.class);
        this.originalMoney = new Money(10.5, "gbp");
        this.holder = new FacetHolderImpl();
        this.adapter = new MoneyValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.adapter);
    }

    private Object createMoney(double amount, String currency) {
        return new Money(amount, currency);
    }

    @Test
    public void testLocale() {
        Assert.assertEquals((Object)Locale.UK, (Object)Locale.getDefault());
    }

    @Test
    public void testEncoding() {
        String data = this.adapter.toEncodedString(this.originalMoney);
        Assert.assertEquals((Object)"10.5 GBP", (Object)new String(data));
    }

    @Test
    public void testDecoding() {
        Object restored = this.adapter.fromEncodedString("23.77 FFR");
        Money expected = new Money(23.77, "FFR");
        Assert.assertEquals((Object)expected, (Object)restored);
    }

    @Test
    public void testTitleOfWithPounds() {
        Assert.assertEquals((Object)"\u00a310.50", (Object)this.adapter.displayTitleOf(this.originalMoney));
    }

    @Test
    public void testTitleOfWithNonLocalCurrency() {
        Assert.assertEquals((Object)"10.50 USD", (Object)this.adapter.displayTitleOf(this.createMoney(10.5, "usd")));
    }

    @Test
    public void testTitleWithUnknownCurrency() {
        Assert.assertEquals((Object)"10.50 UNK", (Object)this.adapter.displayTitleOf(this.createMoney(10.5, "UNK")));
    }

    @Test
    public void testUserEntryWithCurrency() {
        Object money = this.createMoney(10.5, "gbp");
        Object parsed = this.adapter.parseTextEntry(money, "22.45 USD");
        Assert.assertEquals((Object)new Money(22.45, "usd"), (Object)parsed);
    }

    @Test
    public void testUserEntryUsesPreviousCurrency() {
        Object parsed = this.adapter.parseTextEntry(this.originalMoney, "22.45");
        Assert.assertEquals((Object)new Money(22.45, "gbp"), (Object)parsed);
    }

    @Test
    public void testReplacementEntryForDefaultCurrency() {
        Object parsed = this.adapter.parseTextEntry(this.originalMoney, "\u00a380.90");
        Assert.assertEquals((Object)new Money(80.9, "gbp"), (Object)parsed);
    }

    @Test
    public void testSpecifyingCurrencyInEntry() {
        Object parsed = this.adapter.parseTextEntry(this.originalMoney, "3021.50 ffr");
        Assert.assertEquals((Object)"3,021.50 FFR", (Object)this.adapter.displayTitleOf(parsed));
    }

    @Test
    public void testUsingLocalCurrencySymbol() {
        Object parsed = this.adapter.parseTextEntry(this.originalMoney, "\u00a33021.50");
        Assert.assertEquals((Object)"\u00a33,021.50", (Object)this.adapter.titleString(parsed));
    }

    @Test
    public void testInvalidCurrencyCodeIsRejected() throws Exception {
        try {
            this.adapter.parseTextEntry(this.originalMoney, "3021.50  Dm");
            Assert.fail((String)("invalid code accepted " + this.adapter));
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidCurrencySymbolIsRejected() throws Exception {
        try {
            this.adapter.parseTextEntry(this.originalMoney, "\u20ac3021.50");
            Assert.fail((String)("invalid code accepted " + this.adapter));
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testNewValueDefaultsToLocalCurrency() throws Exception {
        Object parsed = this.adapter.parseTextEntry(this.originalMoney, "3021.50");
        Assert.assertEquals((Object)"\u00a33,021.50", (Object)this.adapter.displayTitleOf(parsed));
    }

    @Test
    public void testUnrelatedCurrencySymbolIsRejected() throws Exception {
        Object money = this.createMoney(1.0, "eur");
        try {
            this.adapter.parseTextEntry(money, "$3021.50");
            Assert.fail((String)("invalid code accepted " + this.adapter));
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }
}

