/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.ShortValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ShortWrapperValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class ShortValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private ShortValueSemanticsProviderAbstract value;
    private Short short1;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(ShortValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.short");
                this.will(1.returnValue(null));
            }
        });
        this.short1 = new Short(32);
        this.allowMockAdapterToReturn(this.short1);
        this.holder = new FacetHolderImpl();
        this.value = new ShortWrapperValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.value);
    }

    @Test
    public void testInvalidParse() throws Exception {
        try {
            this.value.parseTextEntry(null, "one");
            Assert.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testTitleOfForPositiveValue() {
        Assert.assertEquals((Object)"32", (Object)this.value.displayTitleOf((Object)this.short1));
    }

    @Test
    public void testTitleOfForLargestNegativeValue() {
        Assert.assertEquals((Object)"-128", (Object)this.value.displayTitleOf((Object)new Short(-128)));
    }

    @Test
    public void testParse() throws Exception {
        Object newValue = this.value.parseTextEntry(null, "120");
        Assert.assertEquals((Object)new Short(120), (Object)newValue);
    }

    @Test
    public void testParseOfOddEntry() throws Exception {
        Object newValue = this.value.parseTextEntry(null, "1,20.0");
        Assert.assertEquals((Object)new Short(120), (Object)newValue);
    }
}

