/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.integration.junit4.JMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.StringValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class StringValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private StringValueSemanticsProvider value;
    private String string;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.string = "text entry";
        this.holder = new FacetHolderImpl();
        this.value = new StringValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.value);
    }

    @Test
    public void testTitleOf() {
        Assert.assertEquals((Object)"text entry", (Object)this.value.displayTitleOf((Object)this.string));
    }

    @Test
    public void testParse() throws Exception {
        Object parsed = this.value.parseTextEntry(null, "tRUe");
        Assert.assertEquals((Object)"tRUe", (Object)parsed.toString());
    }

    @Test
    public void testEncodeNormalString() throws Exception {
        this.allowMockAdapterToReturn("/slash");
        Assert.assertEquals((Object)"//slash", (Object)this.getEncodeableFacet().toEncodedString(this.mockAdapter));
    }

    @Test
    public void testEncodeNULLString() throws Exception {
        this.allowMockAdapterToReturn("NULL");
        Assert.assertEquals((Object)"/NULL", (Object)this.getEncodeableFacet().toEncodedString(this.mockAdapter));
    }

    @Test
    public void testRestore() throws Exception {
        Object parsed = this.value.fromEncodedString("//slash");
        Assert.assertEquals((Object)"/slash", (Object)parsed.toString());
    }

    @Test
    public void testRestoreNULLString() throws Exception {
        Object parsed = this.value.fromEncodedString("/NULL");
        Assert.assertEquals((Object)"NULL", (Object)parsed.toString());
    }
}

