/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.lang;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaClassUtils {
    private static final String JAVA_CLASS_PREFIX = "java.";
    private static Map<String, Class<?>> builtInClasses = new HashMap();

    private static void put(Class<?> cls) {
        builtInClasses.put(cls.getName(), cls);
    }

    private JavaClassUtils() {
    }

    public static Class<?> getBuiltIn(String name) {
        return builtInClasses.get(name);
    }

    public static String[] getInterfaces(Class<?> type) {
        Class<?>[] interfaces = type.getInterfaces();
        Class[] nakedInterfaces = new Class[interfaces.length];
        int validInterfaces = 0;
        for (int i = 0; i < interfaces.length; ++i) {
            nakedInterfaces[validInterfaces++] = interfaces[i];
        }
        String[] interfaceNames = new String[validInterfaces];
        for (int i = 0; i < validInterfaces; ++i) {
            interfaceNames[i] = nakedInterfaces[i].getName();
        }
        return interfaceNames;
    }

    public static String getSuperclass(Class<?> type) {
        Class<?> superType = type.getSuperclass();
        if (superType == null) {
            return null;
        }
        return superType.getName();
    }

    public static boolean isAbstract(Class<?> type) {
        return Modifier.isAbstract(type.getModifiers());
    }

    public static boolean isFinal(Class<?> type) {
        return Modifier.isFinal(type.getModifiers());
    }

    public static boolean isPublic(Class<?> type) {
        return Modifier.isPublic(type.getModifiers());
    }

    public static boolean isJavaClass(Class<?> type) {
        return type.getName().startsWith(JAVA_CLASS_PREFIX) || type.getName().startsWith("sun.");
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    public static List<Class<?>> toClasses(List<Object> objectList) {
        ArrayList classList = new ArrayList();
        for (Object service : objectList) {
            classList.add(service.getClass());
        }
        return classList;
    }

    static {
        JavaClassUtils.put(Void.TYPE);
        JavaClassUtils.put(Boolean.TYPE);
        JavaClassUtils.put(Character.TYPE);
        JavaClassUtils.put(Byte.TYPE);
        JavaClassUtils.put(Short.TYPE);
        JavaClassUtils.put(Integer.TYPE);
        JavaClassUtils.put(Long.TYPE);
        JavaClassUtils.put(Float.TYPE);
        JavaClassUtils.put(Double.TYPE);
    }
}

