/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.lang;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private StringUtils() {
    }

    public static String naturalName(String name) {
        int pos;
        for (pos = 0; pos < name.length() && Character.isLowerCase(name.charAt(pos)); ++pos) {
        }
        if (pos == name.length()) {
            return "invalid name";
        }
        return StringUtils.naturalize(name, pos);
    }

    public static String naturalize(String name) {
        return StringUtils.naturalize(name, 0);
    }

    private static String naturalize(String name, int startingPosition) {
        if (name.length() <= startingPosition) {
            throw new IllegalArgumentException("string shorter than starting position provided");
        }
        StringBuffer s = new StringBuffer(name.length() - startingPosition);
        for (int j = startingPosition; j < name.length(); ++j) {
            if (j > startingPosition && StringUtils.isStartOfNewWord(name.charAt(j), name.charAt(j - 1))) {
                s.append(' ');
            }
            if (j == startingPosition) {
                s.append(Character.toUpperCase(name.charAt(j)));
                continue;
            }
            s.append(name.charAt(j));
        }
        String str = s.toString();
        return str;
    }

    private static boolean isStartOfNewWord(char c, char previousChar) {
        return Character.isUpperCase(c) || Character.isDigit(c) && !Character.isDigit(previousChar);
    }

    public static String capitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String lowerFirst(String argsPhrase) {
        if (argsPhrase == null || argsPhrase.length() == 0) {
            return argsPhrase;
        }
        if (argsPhrase.length() == 1) {
            return argsPhrase.toLowerCase();
        }
        return argsPhrase.substring(0, 1).toLowerCase() + argsPhrase.substring(1);
    }

    public static boolean in(String str, String[] strings) {
        for (String strCandidate : strings) {
            if (!strCandidate.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static String commaSeparatedClassNames(List<Object> objects) {
        StringBuilder buf = new StringBuilder();
        boolean i = false;
        for (Object object : objects) {
            buf.append(object.getClass().getName());
        }
        return buf.toString();
    }

    public static String stripNewLines(String str) {
        return str.replaceAll("[\r\n]", "");
    }

    public static String combine(List<String> list) {
        StringBuffer buf = new StringBuffer();
        for (String message : list) {
            if (list.size() > 1) {
                buf.append("; ");
            }
            buf.append(message);
        }
        return buf.toString();
    }

    public static String firstWord(String line) {
        String[] split = line.split(" ");
        return split[0];
    }

    public static String stripLeadingSlash(String path) {
        if (!path.startsWith("/")) {
            return path;
        }
        if (path.length() < 2) {
            return "";
        }
        return path.substring(1);
    }
}

