/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.logging;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.TriggeringEventEvaluator;
import org.nakedobjects.metamodel.commons.logging.SnapshotAppender;
import org.nakedobjects.metamodel.commons.logging.SnapshotWriter;

public class FileSnapshotAppender
extends SnapshotAppender {
    private static final Logger LOG = Logger.getLogger(FileSnapshotAppender.class);
    private String directoryPath;
    private String extension;
    private String fileName = "log-snapshot-";

    public FileSnapshotAppender(TriggeringEventEvaluator evaluator) {
        super(evaluator);
    }

    public FileSnapshotAppender() {
    }

    public String getDirectory() {
        return this.directoryPath;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setDirectory(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    protected synchronized void writeSnapshot(String message, String details) {
        try {
            String contentType = this.layout.getContentType();
            String fileExtension = this.extension == null || this.extension.length() == 0 ? contentType.substring(contentType.indexOf(47) + 1) : this.extension;
            SnapshotWriter s = new SnapshotWriter(this.directoryPath, this.fileName, fileExtension, message);
            s.appendLog(details);
            s.close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"failed to open log file", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"failed to write log file", (Throwable)e);
        }
    }
}

