/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.logging;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.TriggeringEventEvaluator;
import org.nakedobjects.metamodel.commons.logging.SnapshotAppender;

public class WebSnapshotAppender
extends SnapshotAppender {
    private static final Logger LOG = Logger.getLogger(WebSnapshotAppender.class);
    private String proxyAddress;
    private int proxyPort = -1;
    private String url_spec = "http://development.nakedobjects.net/errors/log.php";

    public WebSnapshotAppender() {
    }

    public WebSnapshotAppender(TriggeringEventEvaluator evaluator) {
        super(evaluator);
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyAddress(String proxyAddess) {
        this.proxyAddress = proxyAddess;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setUrl(String url) {
        this.url_spec = url;
    }

    protected void writeSnapshot(String message, String details) {
        try {
            int c;
            URL url = this.proxyAddress == null ? new URL(this.url_spec) : new URL("http", this.proxyAddress, this.proxyPort, this.url_spec);
            LOG.info((Object)("connect to " + url));
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            HttpQueryWriter out = new HttpQueryWriter(connection.getOutputStream());
            out.addParameter("error", message);
            out.addParameter("trace", details);
            out.close();
            InputStream in = connection.getInputStream();
            StringBuffer result = new StringBuffer();
            while ((c = in.read()) != -1) {
                result.append((char)c);
            }
            LOG.info((Object)result);
            in.close();
        }
        catch (UnknownHostException e) {
            LOG.info((Object)"could not find host (unknown host) to submit log to");
        }
        catch (IOException e) {
            LOG.debug((Object)"i/o problem submitting log", (Throwable)e);
        }
    }

    private static class HttpQueryWriter
    extends OutputStreamWriter {
        private int parameter = 1;

        public HttpQueryWriter(OutputStream outputStream) throws UnsupportedEncodingException {
            super(outputStream, "ASCII");
        }

        public void addParameter(String name, String value) throws IOException {
            if (name == null || value == null) {
                return;
            }
            if (this.parameter > 1) {
                this.write("&");
            }
            ++this.parameter;
            this.write(URLEncoder.encode(name));
            this.write("=");
            this.write(URLEncoder.encode(value));
        }

        public void close() throws IOException {
            this.write("\r\n");
            this.flush();
            super.close();
        }
    }
}

