/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSource;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSourceComposite;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSourceFileSystem;
import org.nakedobjects.metamodel.config.ConfigurationBuilder;
import org.nakedobjects.metamodel.config.ConfigurationBuilderAware;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.NotFoundPolicy;
import org.nakedobjects.metamodel.config.internal.PropertiesConfiguration;
import org.nakedobjects.metamodel.config.internal.PropertiesReader;

public class ConfigurationBuilderAbstract
implements ConfigurationBuilder {
    private static final Logger LOG = Logger.getLogger(ConfigurationBuilderAbstract.class);
    private final ResourceStreamSource resourceStreamSource;
    private final List<ConfigurationResourceAndPolicy> configurationResources = new ArrayList<ConfigurationResourceAndPolicy>();
    private final Properties additionalProperties = new Properties();
    private boolean includeSystemProperties = false;
    private NakedObjectConfiguration cachedConfiguration;

    public ConfigurationBuilderAbstract() {
        this((ResourceStreamSource)new ResourceStreamSourceFileSystem("config"));
    }

    public ConfigurationBuilderAbstract(ResourceStreamSource resourceStreamSource) {
        this.resourceStreamSource = resourceStreamSource;
        this.addDefaultConfigurationResources();
    }

    public ConfigurationBuilderAbstract(ResourceStreamSource ... resourceStreamSources) {
        ResourceStreamSourceComposite composite = new ResourceStreamSourceComposite(new ResourceStreamSource[0]);
        for (ResourceStreamSource rss : resourceStreamSources) {
            composite.addResourceStreamSource(rss);
        }
        this.resourceStreamSource = composite;
        this.addDefaultConfigurationResources();
    }

    protected void addDefaultConfigurationResources() {
        this.addConfigurationResource("nakedobjects.properties", NotFoundPolicy.FAIL_FAST);
        this.addConfigurationResource("web.properties", NotFoundPolicy.CONTINUE);
    }

    public ResourceStreamSource getResourceStreamSource() {
        return this.resourceStreamSource;
    }

    public synchronized void addConfigurationResource(String configurationResource, NotFoundPolicy notFoundPolicy) {
        this.configurationResources.add(new ConfigurationResourceAndPolicy(configurationResource, notFoundPolicy));
        this.invalidateCache();
    }

    public synchronized void setIncludeSystemProperties(boolean includeSystemProperties) {
        this.includeSystemProperties = includeSystemProperties;
        this.invalidateCache();
    }

    public synchronized void add(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.additionalProperties.setProperty(key, value);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("added " + key + "=" + value));
        }
        this.invalidateCache();
    }

    public synchronized void add(Properties properties) {
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.add(key, properties.getProperty(key));
        }
        this.invalidateCache();
    }

    public synchronized NakedObjectConfiguration getConfiguration() {
        if (this.cachedConfiguration != null) {
            return this.cachedConfiguration;
        }
        PropertiesConfiguration configuration = new PropertiesConfiguration(this.getResourceStreamSource());
        this.loadConfigurationResources(configuration);
        this.addShowExplorationOptionsIfNotSpecified(configuration);
        this.addSystemPropertiesIfRequested(configuration);
        this.addAdditionalProperties(configuration);
        this.cachedConfiguration = configuration;
        return this.cachedConfiguration;
    }

    private void loadConfigurationResources(PropertiesConfiguration configuration) {
        for (ConfigurationResourceAndPolicy configResourceAndPolicy : this.configurationResources) {
            this.loadConfigurationResource(configuration, configResourceAndPolicy);
        }
    }

    private void loadConfigurationResource(PropertiesConfiguration configuration, ConfigurationResourceAndPolicy configResourceAndPolicy) {
        String configurationResource = configResourceAndPolicy.getConfigurationResource();
        NotFoundPolicy notFoundPolicy = configResourceAndPolicy.getNotFoundPolicy();
        LOG.info((Object)("loading configuration resource: " + configurationResource + ", notFoundPolicy: " + (Object)((Object)notFoundPolicy)));
        this.loadConfigurationResource(configuration, configurationResource, notFoundPolicy);
    }

    protected void loadConfigurationResource(PropertiesConfiguration configuration, String configurationResource, NotFoundPolicy notFoundPolicy) {
        try {
            PropertiesReader propertiesReader = this.loadConfigurationResource(this.resourceStreamSource, configurationResource);
            this.addProperties(configuration, propertiesReader.getProperties());
            return;
        }
        catch (IOException ex) {
            if (notFoundPolicy == NotFoundPolicy.FAIL_FAST) {
                throw new NakedObjectException("failed to load '" + configurationResource + "'; tried using: " + this.resourceStreamSource.getName());
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("'" + configurationResource + "' not found, but not needed"));
            }
            return;
        }
    }

    private PropertiesReader loadConfigurationResource(ResourceStreamSource resourceStreamSource, String configurationResource) throws IOException {
        return new PropertiesReader(resourceStreamSource, configurationResource);
    }

    private void addShowExplorationOptionsIfNotSpecified(PropertiesConfiguration configuration) {
        if (configuration.getString("nakedobjects.exploration.show") == null) {
            configuration.add("nakedobjects.exploration.show", "yes");
        }
    }

    private void addSystemPropertiesIfRequested(PropertiesConfiguration configuration) {
        if (this.includeSystemProperties) {
            this.addProperties(configuration, System.getProperties());
        }
    }

    private void addAdditionalProperties(PropertiesConfiguration configuration) {
        this.addProperties(configuration, this.additionalProperties);
    }

    protected void addProperties(PropertiesConfiguration configuration, Properties properties) {
        configuration.add(properties);
    }

    private void invalidateCache() {
        this.cachedConfiguration = null;
    }

    public void injectInto(Object candidate) {
        if (ConfigurationBuilderAware.class.isAssignableFrom(candidate.getClass())) {
            ConfigurationBuilderAware cast = (ConfigurationBuilderAware)ConfigurationBuilderAware.class.cast(candidate);
            cast.setConfigurationBuilder(this);
        }
    }

    static class ConfigurationResourceAndPolicy {
        private String configurationResource;
        private NotFoundPolicy notFoundPolicy;

        public ConfigurationResourceAndPolicy(String configurationResource, NotFoundPolicy notFoundPolicy) {
            this.configurationResource = configurationResource;
            this.notFoundPolicy = notFoundPolicy;
        }

        public String getConfigurationResource() {
            return this.configurationResource;
        }

        public NotFoundPolicy getNotFoundPolicy() {
            return this.notFoundPolicy;
        }
    }
}

