/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets;

import java.util.HashMap;
import java.util.Map;
import org.nakedobjects.metamodel.commons.filters.Filter;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetUtil;
import org.nakedobjects.metamodel.facets.MultiTypedFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetHolderImpl
implements FacetHolder {
    private final Map<Class<? extends Facet>, Facet> facetsByClass = new HashMap<Class<? extends Facet>, Facet>();

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        return this.getFacet(facetType) != null;
    }

    @Override
    public void addFacet(Facet facet) {
        this.addFacet(facet.facetType(), facet);
    }

    @Override
    public void addFacet(MultiTypedFacet facet) {
        Class<? extends Facet>[] facetTypes = facet.facetTypes();
        for (int i = 0; i < facetTypes.length; ++i) {
            this.addFacet(facetTypes[i], facet.getFacet(facetTypes[i]));
        }
    }

    private void addFacet(Class<? extends Facet> facetType, Facet facet) {
        Facet existingFacet = this.getFacet(facetType);
        if (existingFacet == null || existingFacet.isNoop()) {
            this.facetsByClass.put(facetType, facet);
            return;
        }
        if (!facet.alwaysReplace()) {
            return;
        }
        if (facet.isDerived() && !existingFacet.isDerived()) {
            return;
        }
        facet.setUnderlyingFacet(existingFacet);
        this.facetsByClass.put(facetType, facet);
    }

    @Override
    public void removeFacet(Facet facet) {
        FacetUtil.removeFacet(this.facetsByClass, facet);
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        FacetUtil.removeFacet(this.facetsByClass, facetType);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> facetType) {
        return (T)this.facetsByClass.get(facetType);
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return FacetUtil.getFacetTypes(this.facetsByClass);
    }

    @Override
    public Facet[] getFacets(Filter<Facet> filter) {
        return FacetUtil.getFacets(this.facetsByClass, filter);
    }
}

