/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.actcoll.typeof;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.nakedobjects.applib.annotation.TypeOf;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetUtil;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromArray;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromGenerics;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacetViaAnnotation;
import org.nakedobjects.metamodel.java5.AnnotationBasedFacetFactoryAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryAware;

public class TypeOfAnnotationFacetFactory
extends AnnotationBasedFacetFactoryAbstract
implements CollectionTypeRegistryAware {
    private CollectionTypeRegistry collectionTypeRegistry;

    public TypeOfAnnotationFacetFactory() {
        super(NakedObjectFeatureType.COLLECTIONS_AND_ACTIONS);
    }

    public boolean process(Method method, MethodRemover methodRemover, FacetHolder holder) {
        TypeOf annotation = this.getAnnotation(method, TypeOf.class);
        Class<?> methodReturnType = method.getReturnType();
        if (!this.collectionTypeRegistry.isCollectionType(methodReturnType) && !this.collectionTypeRegistry.isArrayType(methodReturnType)) {
            return false;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType.isArray()) {
            Class<?> componentType = returnType.getComponentType();
            FacetUtil.addFacet(new TypeOfFacetInferredFromArray(componentType, holder, this.getSpecificationLoader()));
            return false;
        }
        if (annotation != null) {
            return FacetUtil.addFacet(new TypeOfFacetViaAnnotation(annotation.value(), holder, this.getSpecificationLoader()));
        }
        Type type = method.getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            return false;
        }
        Type actualTypeArgument = actualTypeArguments[0];
        if (actualTypeArgument instanceof Class) {
            Class actualType = (Class)actualTypeArgument;
            return FacetUtil.addFacet(new TypeOfFacetInferredFromGenerics(actualType, holder, this.getSpecificationLoader()));
        }
        if (actualTypeArgument instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualTypeArgument;
            return false;
        }
        return false;
    }

    public void setCollectionTypeRegistry(CollectionTypeRegistry collectionTypeRegistry) {
        this.collectionTypeRegistry = collectionTypeRegistry;
    }
}

