/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.encodeable;

import org.nakedobjects.applib.adapters.EncoderDecoder;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.facets.FacetAbstract;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;

public class EncodeableFacetUsingEncoderDecoder
extends FacetAbstract
implements EncodeableFacet {
    private final EncoderDecoder encoderDecoder;
    private final RuntimeContext runtimeContext;
    public static String ENCODED_NULL = "NULL";

    public EncodeableFacetUsingEncoderDecoder(EncoderDecoder encoderDecoder, FacetHolder holder, RuntimeContext runtimeContext) {
        super(EncodeableFacet.class, holder, false);
        this.encoderDecoder = encoderDecoder;
        this.runtimeContext = runtimeContext;
    }

    protected String toStringValues() {
        this.getRuntimeContext().injectDependenciesInto(this.encoderDecoder);
        return this.encoderDecoder.toString();
    }

    public NakedObject fromEncodedString(String encodedData) {
        Assert.assertNotNull(encodedData);
        if (ENCODED_NULL.equals(encodedData)) {
            return null;
        }
        this.getRuntimeContext().injectDependenciesInto(this.encoderDecoder);
        Object decodedObject = this.encoderDecoder.fromEncodedString(encodedData);
        return this.getRuntimeContext().adapterFor(decodedObject);
    }

    public String toEncodedString(NakedObject object) {
        this.getRuntimeContext().injectDependenciesInto(this.encoderDecoder);
        return object == null ? ENCODED_NULL : this.encoderDecoder.toEncodedString(object.getObject());
    }

    private RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }
}

