/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.validate.mandatory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.nakedobjects.applib.annotation.Optional;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetUtil;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.propparam.validate.mandatory.MandatoryFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.mandatory.OptionalFacet;
import org.nakedobjects.metamodel.java5.AnnotationBasedFacetFactoryAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class OptionalAnnotationFacetFactory
extends AnnotationBasedFacetFactoryAbstract {
    public OptionalAnnotationFacetFactory() {
        super(NakedObjectFeatureType.PROPERTIES_AND_PARAMETERS);
    }

    public boolean process(Method method, MethodRemover methodRemover, FacetHolder holder) {
        Class<?> returnType = method.getReturnType();
        if (returnType.isPrimitive()) {
            return false;
        }
        if (!this.isAnnotationPresent(method, Optional.class)) {
            return false;
        }
        Optional annotation = this.getAnnotation(method, Optional.class);
        return FacetUtil.addFacet(this.create(annotation, holder));
    }

    public boolean processParams(Method method, int paramNum, FacetHolder holder) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (paramNum >= parameterTypes.length) {
            return false;
        }
        if (parameterTypes[paramNum].isPrimitive()) {
            return false;
        }
        Annotation[] parameterAnnotations = this.getParameterAnnotations(method)[paramNum];
        for (int j = 0; j < parameterAnnotations.length; ++j) {
            if (!(parameterAnnotations[j] instanceof Optional)) continue;
            return FacetUtil.addFacet(new OptionalFacet(holder));
        }
        return false;
    }

    private MandatoryFacet create(Optional annotation, FacetHolder holder) {
        return annotation != null ? new OptionalFacet(holder) : null;
    }
}

