/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.specloader.internal.introspector;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nakedobjects.metamodel.commons.lang.JavaClassUtils;
import org.nakedobjects.metamodel.facets.MethodScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodFinderUtils {
    private static Map<Class<?>, Class<?>> boxedClasses = new HashMap();

    private MethodFinderUtils() {
    }

    public static Method removeMethod(Method[] methods, MethodScope methodScope, String name, Class<?> returnType, Class<?>[] paramTypes) {
        block0: for (int i = 0; i < methods.length; ++i) {
            Method method;
            int modifiers;
            if (methods[i] == null || !Modifier.isPublic(modifiers = (method = methods[i]).getModifiers()) || !MethodFinderUtils.inScope(methodScope, method) || !method.getName().equals(name) || returnType != null && returnType != method.getReturnType()) continue;
            if (paramTypes != null) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (paramTypes.length != parameterTypes.length) continue;
                for (int c = 0; c < paramTypes.length; ++c) {
                    if (paramTypes[c] != null && paramTypes[c] != parameterTypes[c]) continue block0;
                }
            }
            methods[i] = null;
            return method;
        }
        return null;
    }

    public static boolean inScope(MethodScope methodScope, Method method) {
        boolean isStatic = JavaClassUtils.isStatic(method);
        return isStatic && methodScope == MethodScope.CLASS || !isStatic && methodScope == MethodScope.OBJECT;
    }

    public static List<Method> removeMethods(Method[] methods, MethodScope forClass, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
        ArrayList<Method> validMethods = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            Method method;
            if (methods[i] == null || !MethodFinderUtils.inScope(forClass, method = methods[i])) continue;
            boolean goodPrefix = method.getName().startsWith(prefix);
            boolean goodCount = method.getParameterTypes().length == paramCount;
            Class<?> type = method.getReturnType();
            boolean goodReturn = MethodFinderUtils.returnTypeCompatible(returnType, canBeVoid, type);
            if (!goodPrefix || !goodCount || !goodReturn) continue;
            validMethods.add(method);
            methods[i] = null;
        }
        return validMethods;
    }

    private static boolean returnTypeCompatible(Class<?> returnType, boolean canBeVoid, Class<?> type) {
        if (returnType == null) {
            return true;
        }
        if (canBeVoid && type == Void.TYPE) {
            return true;
        }
        if (type.isPrimitive()) {
            return returnType.isAssignableFrom(boxedClasses.get(type));
        }
        return returnType.isAssignableFrom(type);
    }

    public static void findPrefixedInstanceMethods(Method[] methods, String prefix, List<Method> candidates) {
        for (int i = 0; i < methods.length; ++i) {
            boolean goodCount;
            Method method;
            if (methods[i] == null || JavaClassUtils.isStatic(method = methods[i])) continue;
            boolean goodPrefix = method.getName().startsWith(prefix);
            boolean bl = goodCount = method.getParameterTypes().length == 0;
            if (!goodPrefix || !goodCount) continue;
            candidates.add(method);
        }
    }

    static {
        boxedClasses.put(Boolean.TYPE, Boolean.class);
        boxedClasses.put(Character.TYPE, Character.class);
        boxedClasses.put(Byte.TYPE, Byte.class);
        boxedClasses.put(Short.TYPE, Short.class);
        boxedClasses.put(Integer.TYPE, Integer.class);
        boxedClasses.put(Long.TYPE, Long.class);
        boxedClasses.put(Float.TYPE, Float.class);
        boxedClasses.put(Double.TYPE, Double.class);
        boxedClasses.put(Void.TYPE, Void.class);
    }
}

