/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.value.BigDecimalValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalValueSemanticsProvider
extends ValueSemanticsProviderAbstract
implements BigDecimalValueFacet {
    private static final int TYPICAL_LENGTH = 19;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private static final Object DEFAULT_VALUE = new BigDecimal(0);
    private final NumberFormat format = this.determineNumberFormat("value.format.decimal");

    private static Class<? extends Facet> type() {
        return BigDecimalValueFacet.class;
    }

    public BigDecimalValueSemanticsProvider() {
        this(null, null, null, null);
    }

    public BigDecimalValueSemanticsProvider(FacetHolder holder, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(BigDecimalValueSemanticsProvider.type(), holder, BigDecimal.class, 19, true, true, DEFAULT_VALUE, configuration, specificationLoader, runtimeContext);
    }

    public void setLocale(Locale l) {
    }

    @Override
    protected Object doParse(Object original, String entry) {
        try {
            return new BigDecimal(entry);
        }
        catch (NumberFormatException e) {
            throw new TextEntryParseException("Not an decimal " + entry, e);
        }
    }

    @Override
    public String titleString(Object object) {
        return this.titleString(this.format, object);
    }

    public String titleWithMask(String mask, Object value) {
        return this.titleString(new DecimalFormat(mask), value);
    }

    @Override
    protected String doEncode(Object object) {
        try {
            Class<?> type = object.getClass();
            try {
                return (String)type.getMethod("toPlainString", null).invoke(object, (Object[])null);
            }
            catch (NoSuchMethodException nsm) {
                return (String)type.getMethod("toString", null).invoke(object, (Object[])null);
            }
        }
        catch (Exception e) {
            throw new NakedObjectException(e);
        }
    }

    @Override
    protected Object doRestore(String data) {
        return new BigDecimal(data);
    }

    @Override
    public String toString() {
        return "BigDecimalValueSemanticsProvider: " + this.format;
    }
}

