/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.metamodel.commons.encoding.DataInputStreamExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputStreamExtended;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.encoding.EncodableObject;

public class ByteEncoderDecoderRoundtripTest {
    private DataOutputStreamExtended outputImpl;
    private DataInputStreamExtended inputImpl;

    @Before
    public void setUp() throws Exception {
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        this.outputImpl = new DataOutputStreamExtended((OutputStream)pipedOutputStream);
        this.inputImpl = new DataInputStreamExtended((InputStream)pipedInputStream);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void encodeAndDecodeBoolean() throws IOException {
        this.outputImpl.writeBoolean(true);
        this.outputImpl.writeBoolean(false);
        Assert.assertThat((Object)this.inputImpl.readBoolean(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)true)));
        Assert.assertThat((Object)this.inputImpl.readBoolean(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)false)));
    }

    @Test
    public void encodeAndDecodeByteArray() throws IOException {
        byte[] bytes = new byte[]{3, 76, -1, 21};
        this.outputImpl.writeBytes(bytes);
        byte[] decodedBytes = this.inputImpl.readBytes();
        this.assertThatArraysEqual(bytes, decodedBytes);
    }

    @Test
    public void encodeAndDecodeInt() throws IOException {
        this.outputImpl.writeInt(245);
        this.outputImpl.writeInt(-456);
        Assert.assertThat((Object)this.inputImpl.readInt(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)245)));
        Assert.assertThat((Object)this.inputImpl.readInt(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)-456)));
    }

    @Test
    public void encodeAndDecodeLong() throws IOException {
        this.outputImpl.writeLong(245L);
        this.outputImpl.writeLong(-456L);
        Assert.assertThat((Object)this.inputImpl.readLong(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)245L)));
        Assert.assertThat((Object)this.inputImpl.readLong(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)-456L)));
    }

    @Test
    public void encodeAndDecodeObject() throws IOException {
        this.outputImpl.writeEncodable((Object)new EncodableObject());
        Object object = this.inputImpl.readEncodable(Object.class);
        Assert.assertThat((Object)object, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(EncodableObject.class)));
        EncodableObject encodeableObject = (EncodableObject)object;
        Assert.assertThat((Object)encodeableObject.field, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"test field")));
    }

    @Test
    public void encodeAndDecodeNullObject() throws IOException {
        this.outputImpl.writeEncodable(null);
        Object object = this.inputImpl.readEncodable(Object.class);
        Assert.assertThat((Object)object, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void encodeAndDecodeObjectArray() throws IOException {
        Object[] array = new EncodableObject[]{new EncodableObject(), new EncodableObject(), new EncodableObject()};
        this.outputImpl.writeEncodables(array);
        Encodable[] objects = (Encodable[])this.inputImpl.readEncodables(Encodable.class);
        Assert.assertThat((Object)objects.length, (Matcher)CoreMatchers.is((Object)3));
        EncodableObject encodeableObject = (EncodableObject)objects[2];
        Assert.assertThat((Object)encodeableObject.field, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"test field")));
    }

    @Test
    public void encodeAndDecodeNullObjectArray() throws IOException {
        this.outputImpl.writeEncodables(null);
        Encodable[] objects = (Encodable[])this.inputImpl.readEncodables(Encodable.class);
        Assert.assertThat((Object)objects, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void encodeAndDecodeString() throws IOException {
        this.outputImpl.writeUTF("test");
        this.outputImpl.writeUTF("");
        this.outputImpl.writeUTF("second");
        Assert.assertThat((Object)this.inputImpl.readUTF(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"test")));
        Assert.assertThat((Object)this.inputImpl.readUTF(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((Object)this.inputImpl.readUTF(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"second")));
    }

    @Test
    public void encodeAndDecodeStringArray() throws IOException {
        String[] list = new String[]{"one", "two", "three"};
        this.outputImpl.writeUTFs(list);
        String[] returnedList = this.inputImpl.readUTFs();
        Assert.assertThat((Object)returnedList.length, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)list.length)));
        Assert.assertThat((Object)returnedList[0], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)list[0])));
        Assert.assertThat((Object)returnedList[1], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)list[1])));
        Assert.assertThat((Object)returnedList[2], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)list[2])));
    }

    private void assertThatArraysEqual(byte[] bytes, byte[] decodedBytes) {
        Assert.assertThat((Object)decodedBytes.length, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)bytes.length)));
        for (int i = 0; i < bytes.length; ++i) {
            Assert.assertThat((Object)decodedBytes[i], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)bytes[i])));
        }
    }
}

