/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataInputStreamExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputStreamExtended;
import org.nakedobjects.metamodel.commons.encoding.Encodable;

public abstract class EncodabilityContractTest {
    protected final Mockery context = new JUnit4Mockery();
    protected AuthenticationSession mockAuthSession;
    protected Encodable encodable;

    @Before
    public void setUp() throws Exception {
        this.encodable = this.createEncodable();
        this.mockAuthSession = (AuthenticationSession)this.context.mock(AuthenticationSession.class);
    }

    protected abstract Encodable createEncodable();

    @Test
    public void shouldImplementEncodeable() throws Exception {
        Assert.assertThat((Object)this.encodable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Encodable.class)));
    }

    @Test
    public void shouldHaveOneArgConstructorThatAcceptsInput() {
        Encodable o = this.encodable;
        try {
            o.getClass().getConstructor(DataInputExtended.class);
        }
        catch (Exception e) {
            Assert.fail((String)"could not locate 1-arg constructor accepting a DataInputExtended instance");
        }
    }

    @Test
    public void shouldRoundTrip() throws IOException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        DataOutputStreamExtended outputImpl = new DataOutputStreamExtended((OutputStream)pipedOutputStream);
        DataInputStreamExtended inputImpl = new DataInputStreamExtended((InputStream)pipedInputStream);
        outputImpl.writeEncodable((Object)this.encodable);
        Object decodedEncodable = inputImpl.readEncodable(Object.class);
        this.assertRoundtripped(decodedEncodable, this.encodable);
    }

    protected abstract void assertRoundtripped(Object var1, Object var2);
}

